/*
   device_hardware.h

   Mark Sibenac
   97-1-18
   Atacama Desert Trek
   Field Robotics Center

   This file defines macros and declares some variables and types that are
   hardware dependent. Modify this file whenever hardware changes. Then modify
   device_hardware.cxx.
*/

#ifndef __DEVICE_HARDWARE_H__
#define __DEVICE_HARDWARE_H__

#include "devices.h"
#include "devices/vmio/vmio14.h"
#include "devices/vmio/vmio28.h"
#include "devices/vadc/vadc.h"
#include "devices/vadm/vadm.h"

// These are the quantities of each board in the cage
#define MAX_VMIO14_BOARDS (2)
#define MAX_VMIO28_BOARDS (2)
#define MAX_VADC_BOARDS   (2)
#define MAX_VADM_BOARDS   (1)

// These are the declarations of the board pointers
extern Cvmio14 *vmio14[MAX_VMIO14_BOARDS];
extern Cvmio28 *vmio28[MAX_VMIO28_BOARDS];
extern Cvadc   *vadc[MAX_VADC_BOARDS];  
extern Cvadm   *vadm[MAX_VADM_BOARDS];

// All of the boards, enumerated
typedef enum {VMIO28_BOARD_1, VMIO28_BOARD_2, VMIO14_BOARD_1,
	      VMIO14_BOARD_2, VADC_BOARD_1, VADC_BOARD_2,
	      VADM_BOARD_1, VCPU40_BOARD_1, BOARD_ERROR} Board_Type;

// These are definitions of number of "ports" on each type of board
#define VMIO14_NUM_DI       8
#define VMIO14_NUM_DO       8

#define VMIO28_NUM_ENC      4

#define VADC_NUM_ADC_SINGLE 16
#define VADC_NUM_ADC_DIFF   8

#define VADM_NUM_ADC_SINGLE 16
#define VADM_NUM_ADC_DIFF   8
#define VADM_NUM_DAC        8
#define VADM_NUM_DI         8
#define VADM_NUM_DO         8
#define VADM_NUM_RELAY      4

// These are the device specific parameters for constructor functions
#define VMIO28_1_ADDRESS    ((char *)0x1800)
#define VMIO28_1_BAY        0
#define VMIO28_1_NUM_ENC    4

#define VMIO28_2_ADDRESS    ((char *)0x1800)
#define VMIO28_2_BAY        1
#define VMIO28_2_NUM_ENC    4

#define VMIO14_1_ADDRESS    ((char *)0x00)
#define VMIO14_1_BAY        0
#define VMIO14_1_PORT       0

#define VMIO14_2_ADDRESS    ((char *)0x00)
#define VMIO14_2_BAY        0
#define VMIO14_2_PORT       1

#define VADC_1_ADDRESS      ((char *)0x0)
#define VADC_1_BAY          0
#define VADC_1_SINGLEDIFF   0

#define VADC_2_ADDRESS      ((char *)0x0)
#define VADC_2_BAY          1
#define VADC_2_SINGLEDIFF   1

#define VADM_1_ADDRESS      ((char *)0x4000)
#define VADM_1_SINGLEDIFF   1

// Device pointer mappings from board number
Cdevices *BoardNumToDevicePtr(Board_Type board_num);

extern "C" {
  int InitHardware();
  int KillHardware();
  int RegisterHardware();
}

#endif // __DEVICE_HARDWARE_H__
