/*
   do.h

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level do class. 
   
   Each digital channel is either at high=1 or low=0.

*/

#ifndef __DO_H__
#define __DO_H__

#include "common/nomad_global.h"
#include "devices/devices.h"


class Cdo {
 private:
  int nChan; // actual do channel on device

  Cdevices *pDevice;

  int nValue; // Value last written

 public:
  Cdo();

  static int Register (int num_chan, Cdevices *device_ptr);

  int GetDO () {return nValue;} // returns last set value
  int SetDO (int value);        // sets boolean value

  static char *Name () { return "Cdo"; }
};

extern Cdo *dout; // array of do's

#endif // __DO_H__







