/*
   vmio28.h

   VME I/O Class Header File
   VMIO-28 Piggy Back for a VMIO-10 card (opto-isolated encoder input)

   97-1-8
   Mark Sibenac
   Field Robotics Center
   Lunar Rover Terrestrial Prototype

   nVmioBay = (0->P5,P6,P9,P10;01-16,   1->P3,P4,P7,P8;17-32)
   pBoardVmeAddress (VMIO10) = I/O address on VMEbus (not short space)
*/

#ifndef __VMIO28_CWRAP_H__
#define __VMIO28_CWRAP_H__

#include "common/nomad_global.h"
#include "vmio28.h"

const char *vmioAddress = (char *)0x1800;
const int vmioBay = 0;

extern Cvmio28 *vmio28;

extern "C" {
  int init28 ();
  int selectMode12 (Byte cMode12);
  int counterReset ();
  int presetCounter (int nCounter, int nCount);
  int getCounter (int nCounter);
  int vmio28Scope (int freq);
}

#endif // __VMIO28_CWRAP_H__
