/* 
   vadm_cwrap.h

   Mark Sibenac
   96-5-20 Created
   96-1-6 Modified
   Field Robotics Center
   Lunar Rover Terrestrial Prototype

   These are the "c" wrappers to the C++ class, Cvadm.
   */

#ifndef __VADM_CWRAP_H__
#define __VADM_CWRAP_H__

#include "vadm.h"

extern Cvadm *vadm;

#define VADM_BOARD_ADDRESS 0x4000
#define VADM_INPUT_MODE SINGLE_ENDED

extern "C" {
  
  char *initVadm (void);

  int   setDACI (int nChannel, int nValue);
  float setDACF (int nChannel, float fValue);
  int   playDAC (int nChannel);

  int   getADCI(int nChannel);
  float getADCF(int nChannel);

  int setDO(unsigned char bitmap);
  int setDOhigh(unsigned char bitmask);
  int setDOlow(unsigned char bitmask);
  int getDI(void);
  void enableDigital(void);
  void disableDigital(void);

  int setRelays(unsigned char bitmap);
}

#endif
