/* 
   vadm.h

   Mark Sibenac
   Lunar Rover Terrestrial Prototype
   Field Robotics Center
   96-5-15 original
   97-1-6  modified

   This is the header to the vadm interface.
   */

#ifndef __VADM_H__
#define __VADM_H__

#include "common/nomad_global.h"
#include "devices/devices.h"
#include "semLib.h"

#define VADM_DO_OFFSET (0x00)
#define VADM_DORB_OFFSET (0x00)
#define VADM_ADSTART_OFFSET (0x08)
#define VADM_ADC_OFFSET (0x08)
#define VADM_ADMUX_OFFSET (0x10)
#define VADM_DACA_OFFSET (0x18)
#define VADM_DI_OFFSET (0x20)
#define VADM_DACB_OFFSET (0x38)

class Cvadm : public Cdevices {
private:
  const double  VOLT_PER_BIT = 0.0048828125; // (10 - (-10)) / 2^12

  unsigned char cRelay_map;

  int   SetDACI   (int nChannel, int nValue);
  int   GetADCI   (int nChannel);
  int   GetDI     (void);
  int   SetDO     (unsigned char bitmap);
  int   SetDOhigh (unsigned char bitmask);
  int   SetDOlow  (unsigned char bitmask);
  int   SetRelays (unsigned char bitmap);


protected:
  int nSingleDiff; // 0-Single-Ended, 1-Differential

  WordRegister pDO;
  WordRegister pDORB;
  WordRegister pADSTART;
  WordRegister pADC;
  WordRegister pADMUX;
  WordRegister pDACA;
  WordRegister pDI;
  WordRegister pDACB;

  SEM_ID       m_Mutex; // mutual exclusion semaphore

public:
  Cvadm(const char *pBoardVmeAddress, int nSingleDiff_in); /* Constructor;
			     pBoardVmeAddress is VME address (not local) */
 ~Cvadm (); // Destructor

  // Interface functions
  virtual int    Init      ();
  virtual int    SetDAC    (int nChannel, double fValue); 
  virtual double GetADC    (int nChannel); 
  virtual int    GetDI     (int nChannel); 
  virtual int    SetDO     (int nChan, int nValue);
  virtual int    EnableDO  ();
  virtual int    DisableDO ();
  virtual int    SetRelay  (int nChan, int nState);
};

#endif /* __VADM_H__ */   
