/*
  joy.c
  
  96-6-7
  Mark Sibenac
  Field Robotics Center
  Lunar Rover Terrestrial Prototype
  TRIWG Stuff with Ambler Amps

  Based upon a program written by Ryan Miller.

  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "serial.h"
#include "joy.h"

int fd = 0;
char pPort[20];

void joyMain(char *pPort_in)
{
  joystruct joy;

  printf("Ryan and Jorgen's and now Mark's Joystick play program\n");
  printf("To stop, press left trigger only\n");
  printf("Okay, play with it\n\n");
  strcpy(pPort, pPort_in);

  fd = 0;
  joy.left_trigger = 0; joy.right_trigger = 0;

  while(!(joy.left_trigger && !joy.right_trigger))
    {
      read_joystick(&joy);
      if (joy.left_trigger && joy.right_trigger)
	{
	  printf("Left: (%f,%f) Right (%f,%f) Triggers (%d, %d)\n",
		 joy.left_x, joy.left_y,
		 joy.right_x, joy.right_y,
		 joy.left_trigger, joy.right_trigger);
	}
    }
  close_joystick();
}


void close_joystick() 
{
  if (fd != 0) 
     close(fd);
}

unsigned char serial_getchar()
{
  char n;

  serialGetBuf(fd, &n, 1, -1);
  return n;
}


int read_joystick(joystruct *joy)
{
  unsigned char done, temp;
  int checksum;

  if (fd == 0)
    {	
      printf("Attempting joystick connection on port %s at 9600 baud\n", pPort);
      fd = serialInit(pPort, 9600);
      if (fd == 0) 
	{
	  printf("Couldn't connect\n");
	  return -1;
	}
      else
	{
	  printf("Connected thru serialInit()...\n");
	}
    }
  
  serialFlushBuffer(fd);
  
restart:
  
  /* NODE 1: Wait for packet start (0xff) */
  if (serial_getchar() != 0xff) goto restart;

  done = 0;
  while (!done) 
    {
      checksum = 0;

      /* NODE 2: get left x data */
      if ((temp = serial_getchar()) == 0xff) continue;
      joy->left_x = (temp * 100.0)/ 254.0;
      checksum += temp;
	
      /* NODE 3: get left y data */
      if ((temp = serial_getchar()) == 0xff) continue;
      joy->left_y = (temp * 100.0) / 254.0;
      checksum += temp;
      
      /* NODE 4: get right x data */
      if ((temp = serial_getchar()) == 0xff) continue;
      joy->right_x = (temp * 100.0)/ 254.0;
      checksum += temp;
      
      /* NODE 5: get right y data */
      if ((temp = serial_getchar()) == 0xff) continue;
      joy->right_y = (temp * 100.0) / 254.0;
      checksum += temp;
      
      /* NODE 6: get left pedal data */
      if ((temp = serial_getchar()) == 0xff) continue;
      joy->left_pedal = (temp * 100.0)/ 254.0;
      checksum += temp;
      
      /* NODE 7: get right pedal data */
      if ((temp = serial_getchar()) == 0xff) continue;
      joy->right_pedal = (temp * 100.0) / 254.0;
      checksum += temp;
      
      /* NODE 8: get other data */
      if ((temp = serial_getchar()) == 0xff) continue;
      joy->left_trigger = (temp & 0x01) ? 1 : 0;
      joy->right_trigger = (temp & 0x02) ? 1 : 0;
      checksum += temp;
      
      /* NODE 9: get checksum */
      temp = serial_getchar();
      if (temp != (checksum  & 0xff)) goto restart;
      
      done = 1;
    }  

  return 0;
}	

