/*
   test_compass.cxx

   Mark Sibenac
   97-2-6
   Atacama Desert Trek
   Field Robotics Center

   This tests the compass interface.

*/

#include "test_compass.h"
#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"
#include "usrLib.h"
#include "modules/pointing/point.h"

Compass *compass;

int compass_Init ()
{
  compass = new Compass();
  compass->init("/tyCo/1", 20, 0);
  sp((FUNCPTR)compass_Scope,20,2,3,4,5,6,7,8,9);
  return 0;
}

int compass_Pitch  ()
{
  int pitch;

  compass->updateState();
  pitch = compass->getPitch();
  printf("Pitch = %f\n", double(pitch)/10.0);
  return pitch;
}
int compass_Roll ()
{
  int roll;

  compass->updateState();
  roll = compass->getRoll();
  printf("Roll = %f\n", double(roll)/10.0);
  return roll;
}

int compass_Azimuth ()
{
  int azimuth;

  compass->updateState();
  azimuth = compass->getAzimuth();
  printf("Azimuth = %f\n", double(azimuth)/10.0);
  return azimuth;
}

int compass_Kill ()
{
  delete compass;
  return 0;
}


// captures to stethoscope at freq
int compass_Scope (int freq)
{
  double Az, Pitch, Roll, antAz, antPitch;

  if ((freq < 0) || (freq > sysClkRateGet()))
    {
      printf("freq = %d must be between 0 and %d\n", freq, sysClkRateGet());
      return -1;
    }

  ScopeInstallSignal("Azimuth", "degrees", &Az, "double", 0);
  ScopeInstallSignal("Pitch", "degrees", &Pitch, "double", 0);
  ScopeInstallSignal("Roll", "degrees", &Roll, "double", 0);
  ScopeInstallSignal("AntAzimuth", "rad", &antAz, "double", 0);
  ScopeInstallSignal("AntPitch", "rad", &antPitch, "double", 0);

  ScopeChangeSampleRate(double(freq), 0);

  while(1)
    {
      compass->updateState();
      Az = compass->getAzimuth()/10.0;
      Pitch = compass->getPitch()/10.0;
      Roll = compass->getRoll()/10.0;
      antAz = pElevation->_antAng[0];
      antPitch = pElevation->_antAng[1];

      ScopeCollectSignals(0);
      taskDelay(sysClkRateGet()/freq);
    }

  return 0;
}

