/*
   point.h

   Mark Sibenac
   97-2-4
   Atacama Desert Trek
   Field Robotics Center

   This module handles the two pointing system motors (azimuth, pitch).

   Each motor can be in one of the following states: {INHIBITED, SERVOING,
   OVERCURRENT, OVERTEMP, ERROR}

*/

#ifndef __POINT_H__
#define __POINT_H__

#include "common/nomad_global.h"
#include "components/amps/amps.h"
#include "components/pid/pid.h"
#include "components/traject/traject.h"
#include "semLib.h"

// wrapper to UpdateServo function
int UpdatePointServoFun (int axis);

class Cpoint {
 private:
  motor_state_t m_state; // motor state
  int           m_axis_number;
  double        m_fTargetAngle; // in radians [-PI,PI]

 public:
  Cpoint (int axis_number, Camps *amp_in, int angular, int priority=100);
  ~Cpoint ();

  int           Init          ();
  int           UpdateServo   ();
  int           ChangeState   (motor_state_t state);
  motor_state_t GetState      () {return m_state;}
  int           SetTarget     (double fTargetAngle);
  double        GetTarget     () {return m_fTargetAngle;}

  Camps        *m_amp; // Angular 400 ticks/rev motor shaft
  Cpid          m_pid; // PID controller
  Ctraject      m_trajectory; // Trapezoidal trajectory generator
  SEM_ID        m_semUpdate; /* semaphore to control execution 
				 of the servo loop */
  int           Transform ();
  double _antPos[3];       //Antenna position (now [0,0,0])
  double _roverPos[3];     //Rover position   (now [1000,0,0])
  double _stationPos[3];   //Station position (now [0,0,0])
  double _roverAng[3];     //Rover attitude (now [yaw,pitch,roll])
  double _antAng[3];       //Output         (now [yaw,pitch])
};

extern Cpoint **point; // array of point object pointers

extern Cpoint *pAzimuth;
extern Cpoint *pElevation;

#endif // __POINT_H__

