/*
  modules.cxx

  97-1-22
  Mark Sibenac
  Atacama Desert Trek
  Field Robotics Center

*/

#include "modules.h"
#include "modules/drive/drive.h"
#include "modules/pointing/point.h"
#include "components/components.h"
#include "modules/drive/drivesys.h"

Cdrivesys *drivesys;

int InitModules ()
{
  drivesys = new Cdrivesys;
  
  pAzimuth   = new Cpoint(0, pAzimuthAmp, 1, 79); // Angular
  pElevation = new Cpoint(1, pElevationAmp, 1, 79); // Angular
  
  point      = new (Cpoint *)[2];
  point[0]   = pAzimuth;
  point[1]   = pElevation;

  pAzimuth->Init();
  pElevation->Init();

  return 0;
}
