/*
   drivesys.cxx

   Mark Sibenac
   97-2-18
   Atacama Desert Trek
   Field Robotics Center

   This module is responsible for handling the four drive motors.

*/

#include "drivesys.h"
#include "components/amps/amps.h"
#include "taskLib.h"

int DrivePIDFun (int pDrivesys, int, int, int, int, int, int, int, int, int)
{
  return (((Cdrivesys *)(pDrivesys))->UpdateServos());
}

Cdrivesys::Cdrivesys()
{
  pFL = pFR = pBL = pBR = 0;
}

Cdrivesys::~Cdrivesys()
{
  char pString[20];
  int tid;
  
  semFlush (m_semServo);
  semDelete (m_semServo);

  sprintf(pString, "tDSPID");
  if ((tid = taskNameToId(pString)) != -1) taskDelete (tid);

  delete pFL;
  delete pFR;
  delete pBL;
  delete pBR;
}

int Cdrivesys::Init ()
{
  char pString[20];
  int tid;
  
  if (!(m_semServo = semBCreate (SEM_Q_FIFO, SEM_EMPTY)))
    {
      Dprintf(("Cdrivesys::Cdrivesys() semBCreate() was not able to allocate "
	       "memory.\n"));
      return -1;
    }

  sprintf(pString, "tDSPID");
  if ((tid = taskNameToId(pString)) != -1) taskDelete (tid);
  taskSpawn (pString, PRIORITY_DSPID, VX_SUPERVISOR_MODE | VX_DEALLOC_STACK | 
	     VX_FP_TASK | VX_STDIO, 20000, (FUNCPTR)DrivePIDFun, 
	     (int)this, 0, 0, 0, 0, 0, 0, 0, 0, 0);

  pFL = new Cdrive(0, &amp[0]);
//  pFR = new Cdrive(1, &amp[1]);
//  pBL = new Cdrive(2, &amp[2]);
//  pBR = new Cdrive(3, &amp[3]);

  pFL->Init (1.0, 1.0, 1.0, 1.0, 1.0, 0.1, 1);
//  pFR->Init (1.0, 1.0, 1.0, 1.0, 1.0, 0.1, 1);
//  pBL->Init (1.0, 1.0, 1.0, 1.0, 1.0, 0.1, 1);
//  pBR->Init (1.0, 1.0, 1.0, 1.0, 1.0, 0.1, 1);
  
  return 0;
}

int Cdrivesys::UpdateServos ()
{
  while (1)
    {
      semTake (m_semServo, WAIT_FOREVER);

      if (pFL) pFL->UpdateServo();
      if (pFR) pFR->UpdateServo();
      if (pBL) pBL->UpdateServo();
      if (pBR) pBR->UpdateServo();
    }
}

int Cdrivesys::SetUpdateFreq (int pid_freq, int traj_freq)
{
  if (pFL) pFL->SetUpdateFreq (pid_freq, traj_freq);
  if (pFR) pFR->SetUpdateFreq (pid_freq, traj_freq);
  if (pBL) pBL->SetUpdateFreq (pid_freq, traj_freq);
  if (pBR) pBR->SetUpdateFreq (pid_freq, traj_freq);
  return 0;
}
