/*
   adc.cxx

   Mark Sibenac
   97-1-27
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level adc class.

*/

#include "adc.h"
#include "robot/robot.h"

Cadc *adc; // array of adcs

static int nTotalChannelsAlloced = 0;
static int nTotalChannelsRegistered = 0;


Cadc::Cadc()
{
  Dprintf(("Cadc::Cadc() creating new adc object\n"));

  fValue = double(0.0);
  nTotalChannelsAlloced++;
}

int Cadc::Register (int num_chan, Cdevices *device_ptr)
{
  ASSERT (num_chan >= 0);
    
  Dprintf(("Cadc::Register() called with num_chan=%d, nTotalChannelsAlloced=%d"
	   ", nTotalChannelsRegistered before call=%d\n", num_chan, 
	   nTotalChannelsAlloced, nTotalChannelsRegistered));

    for (int n=0; n < num_chan; n++)
      {  
	if (nTotalChannelsRegistered >= nTotalChannelsAlloced)
	  {
	    Dprintf(("Cadc::Register() too many channels registered.\n"));
	    return (-1);
	  }

	adc[nTotalChannelsRegistered].nChan   = n;
	adc[nTotalChannelsRegistered].pDevice = device_ptr;

	++nTotalChannelsRegistered;
      }

  return 0;
}

double Cadc::GetADC()
{
  fValue = pDevice->GetADC(nChan);

  return (fValue);
}





