/*
  components.cxx

  97-1-22
  Mark Sibenac
  Atacama Desert Trek
  Field Robotics Center

*/

#include "components.h"

// Pointing Module components
Camps *pAzimuthAmp;
Camps *pElevationAmp;

Camps *amps;

int InitComponents ()
{
  pAzimuthAmp   = new Camps(1, 1000*150);// Angular
  pElevationAmp = new Camps(1, 1000*88); // Angular

  // Since no temperature sensor is on this motor, set temp_in=0
  pAzimuthAmp->Init(&encoder[4], &adc[4], &dac[6], &di[4], 0, &dout[6]);
  pElevationAmp->Init(&encoder[5], &adc[5], &dac[7], &di[5], 0, &dout[7]);

  amps = new Camps[1](0, 1024);
  amps[0].Init(&encoder[0], &adc[0], &dac[0], &di[0], &di[1], &dout[0]);

  return 0;
}

int KillComponents ()
{
  delete pAzimuthAmp;
  delete pElevationAmp;
  delete amps;

  return 0;
}
