/*
 * 
 * compass.h
 *
 * Mark Sibenac
 * Atacama Desert Trek
 * 96-12-18
 *
 * This is the header file that describes the compass class. It is for the KVH
 * Azimuth Digital Gyro Compass.
 *
 * To use, first create a Compass object. Then call init() with an appropriate
 * serial device name (like "/tyCo/1") and initialization parameters, rate and
 * offset. If last two parameters are omitted, a default rate of 10Hz and
 * 000.0 degrees offset are assumed.
 *
 * A baud rate of 9600 baud is assumed.
 *
 * If auto-calibration switch is in the on position on the KVH ADGC, the getX
 * memeber functions will return ADGC_ERROR;
 */

#ifndef __COMPASS_H__
#define __COMPASS_H__

#include "common/nomad_global.h"

const int ADGC_ERROR = -6666;

class Compass {
 private:
  int nPitch; // tenths of degrees
  int nRoll;  // tenths of degrees
  int nAzimuth; // tenths of degrees, magnetic heading + internal offset

  int nRate; // rate of update (1,2,5,10,20) in Hz
  int nOffset; // offset in tenths of degrees
  
  int fd; // file descriptor of device


 public:
  Compass (); // constructor
  ~Compass(); // destructor

  int init (char *pSerialDeviceName, int nRate=20, int nOffset=0); /* sets
	   up the updateState function in the background and initializes
	   the binary semaphore. Also sends an initialization command to
	   the compass. */
  
  int setOffset (int nOffset); /* sends an offset change command */

  void updateState (); // task that updates registers
  

  int getPitch() { return nPitch; }
  int getRoll() { return nRoll; }
  int getAzimuth() { return nAzimuth; }

};

#endif // __COMPASS_H__
