// File: compass.cxx
// created: 960206
// description: blah blah blah


#include "compass.h"
#include "ioLib.h"
#include "interfaces/serial/serial.h"

/* update the registers */
void Compass::updateState()
{
  int pitch, roll, azimuth, neg, i = 0;
  char buf[80];
  int num_chars;

  buf[i++] = 0;
  while (buf[0] != '%')
    num_chars = serialGetBuf(fd, buf, 79, 0); // read a line from serial port
  buf[num_chars]=0;

  pitch = 0;
  neg = 0;
  while ((buf[i] != ',') && (i < 79)) {
    if (buf[i] == '-')
      neg = 1;
    else {
      pitch *= 10;
      pitch += buf[i] - '0';
    }
    i++;
  }
  if (neg)
    pitch *= -1;

  i++;
  roll = 0;
  neg = 0;
  while ((buf[i] != ',') && (i < 79)) {
    if (buf[i] == '-')
      neg = 1;
    else {
      roll *= 10;
      roll += buf[i] - '0';
    }
      i++;
  }
  if (neg)
    roll *= -1;

  i++;
  azimuth = 0;
  neg = 0;
  while ((buf[i] != '\r') && (i < 79)) {
    if (buf[i] == '-')
      neg = 1;
    else {
      azimuth *= 10;
      azimuth += buf[i] - '0';
    }
      i++;
  }
  if (neg)
    azimuth *= -1;

  if (i >= 79) // got an error - do something about it here 
    ;          // since max line length is 17 this must be bad...

  nPitch = pitch;
  nRoll = roll;
  nAzimuth = azimuth;
}


Compass::Compass()
{
  // I don't think there's anything to do here.. but we'll init variables
  nPitch = 0;
  nRoll = 0;
  nAzimuth = 0;

  nRate = 20;
  nOffset = 0;
}


Compass::~Compass()
{
  // close serial port to be nice
  close(fd);
}


/* sets up the updateState function in the background and initializes
   the binary semaphore. Also sends an initialization command to the compass.
   (uh, right now there is no semaphore...)
*/  
int Compass::init(char *pSerialDeviceName, int nRate_in, int nOffset_in)
{
  // open serial port at 9600 bps and no parity
  fd = serialInit(pSerialDeviceName, 9600);
  // put port in line mode
  ioctl(fd, FIOSETOPTIONS, OPT_LINE);
  ioctl(fd, FIOFLUSH, 0);


  this->nRate = nRate_in;
  this->nOffset = nOffset_in;
  return 0;
}


// change offset 
int Compass::setOffset(int nOffset_in)
{
  this->nOffset = nOffset_in;
  return 0;
}
