/*
   test_point.h

   Mark Sibenac
   97-2-5
   Atacama Desert Trek
   Field Robotics Center

   This tests the pointint module.

*/

#ifndef __TEST_POINT_H__
#define __TEST_POINT_H__

#include "modules/pointing/point.h"

extern "C" {
  int point_Init        (int freq);
  int point_servoISR   (int);
  void point_startISR   (int freq, int max_points);
  void point_stopISR    ();
  int point_ChangeState (int point_num, motor_state_t value);
  int point_GetState    (int point_num);
  int point_GetPID      (int point_num);
  int point_GetAmp      (int point_num);
  int point_SetPID      (int point_num);
  int point_SetDes      (int point_num, double des);
  int point_SetAmp      (int point_num);
  int point_Disable     (int point_num);
  int point_Enable      (int point_num);
  int point_Scope       (int point_num, int freq); // captures to stethoscope at freq
  int point_SetTarget   (int point_num);
  int point_SetTargetAngle (int point_num, double fAngle);
  int point_SetTraject  (int point_num);
  int point_GetTraject  (int point_num);
  int point_Reset       (int point_num);
  int point_Home        ();
  int point_Demo        ();
}

#endif // __TEST_POINT_H__
