/*
   drivesys.h

   Mark Sibenac
   97-2-18
   Atacama Desert Trek
   Field Robotics Center

   This module is responsible for handling the four drive motors.

*/

#ifndef __DRIVESYS_H__
#define __DRIVESYS_H__

#include "common/nomad_global.h"
#include "semLib.h"
#include "drive.h"

#define PRIORITY_DSPID 80

class Cdrivesys {
 private:
  
  SEM_ID  m_semServo;   // semaphore to signal updating Servos

 public:
  Cdrivesys ();
 ~Cdrivesys ();
  
  int     Init          (); // must call this first, after amps are intialized

  int     UpdateServos  (); // updates the 4 Servo controllers
  int     SetUpdateFreq (int pid_freq, int traj_freq);
  SEM_ID  GetSemServo   () { return m_semServo; }

  Cdrive *pFL; // front-left wheel
  Cdrive *pFR; // front-right wheel
  Cdrive *pBL; // back-left wheel
  Cdrive *pBR; // back-right wheel
};

extern Cdrivesys *drivesys;

#endif // __DRIVESYS_H__

