/*
   point.h

   Mark Sibenac
   97-2-4
   Atacama Desert Trek
   Field Robotics Center

   This module handles the two pointing system motors (azimuth, pitch).

   Each motor can be in one of the following states: {INHIBITED, SERVOING,
   OVERCURRENT, OVERTEMP, ERROR}

*/

#ifndef __POINT_H__
#define __POINT_H__

#include "common/nomad_global.h"
#include "components/amps/amps.h"
#include "components/pid/pid.h"
#include "components/traject/traject.h"
#include "semLib.h"

// wrapper to UpdateServo function
int UpdatePointServoFun (int axis);

class Cpoint {
 private:
  motor_state_t m_state; // motor state
  int           m_axis_number;

 public:
  Cpoint (int axis_number, Camps *amp, int priority=100);
  ~Cpoint ();

  int           Init          ();
  int           UpdateServo   ();
  int           ChangeState   (motor_state_t state);
  motor_state_t GetState      () {return m_state;}

  Camps        *m_amp; // Angular 400 ticks/rev motor shaft
  Cpid          m_pid; // PID controller
  Ctraject      m_trajectory; // Trapezoidal trajectory generator
  SEM_ID        m_semUpdate; /* semaphore to control execution 
				 of the servo loop */
};

extern Cpoint **point; // array of point object pointers

extern Cpoint *pAzimuth;
extern Cpoint *pElevation;

#endif // __POINT_H__

