/*
   drive.h

   Mark Sibenac
   97-1-28
   Atacama Desert Trek
   Field Robotics Center

   This module controls the coordinated motion and velocity servo loops on the
   four motors. It handles the PID loops and the trajectory generator
   algorithms.

   Each motor can be in one of the following states: {INHIBITED, SERVOING,
   OVERCURRENT, OVERTEMP, ERROR}

*/

#ifndef __DRIVE_H__
#define __DRIVE_H__

#include "common/nomad_global.h"
#include "components/amps/amps.h"
#include "components/pid/pid.h"
#include "components/traject/traject.h"
#include "semLib.h"

class Cdrive;

int UpdateServoFun (...); // wrapper to UpdateServo function

class Cdrive {
 private:
  motor_state_t m_state; // motor state
  int           m_axis_number;

 public:
  Cdrive (int axis_number, Camps *amp, int priority=100);
  ~Cdrive ();

  int           Init          ();
  int           UpdateServo   ();
  int           ChangeState   (motor_state_t state);
  motor_state_t GetState      () {return m_state;}

  Camps        *m_amp; // angular and 1024 ticks/rev
  Cpid          m_pid; // PID controller
  Ctraject      m_trajectory; // Trapezoidal trajectory generator
  SEM_ID        m_semUpdate; /* semaphore to control execution 
				 of the servo loop */
};

extern Cdrive *drive; // array of drive objects

#endif // __DRIVE_H__

