/*
   encoder.h

   Mark Sibenac
   97-1-21
   Atacama Desert Trek
   Field Robotics Center

   This is the interface level encoder class. It assumes the device is a
   24 bit unsigned encoder board.

*/

#ifndef __ENCODER_H__
#define __ENCODER_H__

#include "common/nomad_global.h"
#include "devices/devices.h"

class Cencoder {
 private:

  int nPort; // actual encoder chip number on device

  Cdevices *pDevice;

 public:
  Cencoder();

  static int Register (int num_chan, Cdevices *device_ptr);

  int GetEncoder ();
  int PresetEncoder (int value);
  int SelectMode (int mode);

  static char *Name () { return "Cencoder"; }
};

extern Cencoder *encoder; // array of encoders

#endif // __ENCODER_H__







