/*
   vmio28.h

   VME I/O Class Header File
   VMIO-28 Piggy Back for a VMIO-10 card (opto-isolated encoder input)

   97-1-8
   Mark Sibenac
   Field Robotics Center
   Lunar Rover Terrestrial Prototype

   nVmioBay = (0->P5,P6,P9,P10;01-16,   1->P3,P4,P7,P8;17-32)
   pBoardVmeAddress (VMIO10) = I/O address on VMEbus (not short space)

   Device configures to mode 1 - single count synchronous with UA1 on creation.
*/

#ifndef __VMIO28_H__
#define __VMIO28_H__

#include "common/nomad_global.h"
#include "vmio10.h"

class Cvmio28 : public Cvmio10 {
 private:
  Byte cMode01; // Mode 1..7 from counter 1 and 2
  Byte cMode23; // Mode 1..7 from counter 3 and 4
  Byte cCs;     // Chip select

 protected:

 public:
  Cvmio28 (const char *pBoardVmeAddress_in, int nVmioBay_in); 

  int SelectMode (int enc_num, Byte cMode); // Mode select for enc_num
  int CounterReset (); // Reset all counters
  int PresetEncoder (int nCounter, int nCount); // Preset nCounter with nCount
  int GetEncoder (int nCounter); // Get the current value of nCounter
};
  
#endif // __VMIO28_H__

