/*
   vmio22.h

   VME I/O Class Header File
   VMIO-22 Piggy Back for a VMIO-10 card (opto-isolated A->D)

   96-12-19
   Mark Sibenac
   Field Robotics Center
   Lunar Rover Terrestrial Prototype

   This device assumes you are in -10V to 10V mode and returns a twos 
   complement number from -10V to 10V or -2048 to 2048.

   nSingleDiff = (0-Single-ended, 1-Differential)
   nVmioBay = (0->P5,P6,P9,P10;01-16,   1->P3,P4,P7,P8;17-32)
   pBoardVmeAddress (VMIO10) = I/O address on VMEbus (not short space)
*/

#ifndef __VMIO22_H__
#define __VMIO22_H__

#include "common/nomad_global.h"
#include "vmio10.h"
#include "../devices.h"

class Cvmio22 : public Cvmio10 {
private:
  const double VOLT_PER_BIT = 0.0048828125; // (10 - (-10)) / 2^12

  ByteRegister pA, pB, pC; // pPort_[01]X depending on nVmioBay

protected:
  int nSingleDiff; // 0-Single-Ended, 1-Differential
  int nVmioBay; // 0->vme01-16, 1->vme17-32

public:
  Cvmio22(const char *pBoardVmeAddress_in, int nVmioBay_in, int nSingleDiff_in); 

  int   GetADCI(int nChannel);
  double GetADCF(int nChannel);
  int   GetSingleDiff() {return nSingleDiff;};
};
  
#endif // __VMIO22_H__

