/* 
   vmio10.h

   VME I/O Library Header File
   VMIO-10 Board

   96-12-18
   Mark Sibenac
   Field Robotics Center
   Lunar Rover Terrestrial Prototype

   
   vmioBay := 0 -> P5,P6,P9,P10; 01-16; chip 1, IC7
              1 -> P3,P4,P7,P8; 17-32, chip 0, IC6
   cPortX_invert := 0->non-invert, 1->invert (each bit)
   cPortX_dir := 0->output, 1->input (each bit)
   boardBaseAddress = short I/O address on VMEbus
*/

#ifndef __VMIO10_H__
#define __VMIO10_H__

#include "common/nomad_global.h"
#include "../devices.h"

#define CNTL0_OFFSET   0x31
#define PORT_0A_OFFSET 0x21
#define PORT_0B_OFFSET 0x11
#define PORT_0C_OFFSET 0x01

#define CNTL1_OFFSET   0x39
#define PORT_1A_OFFSET 0x29
#define PORT_1B_OFFSET 0x19
#define PORT_1C_OFFSET 0x09

#define PORT_A_OFFSET 0x22
#define PORT_B_OFFSET 0x2a
#define PORT_C_OFFSET 0x05

class Cvmio10 : public Cdevices {
 private:

  int nVmioBay;  /* 0 -> P5,P6,P9,P10; 01-16; chip 1, IC7
                    1 -> P3,P4,P7,P8; 17-32, chip 0, IC6 */

 protected:

  ByteRegister pCntl;
  ByteRegister pPortA;
  ByteRegister pPortB;
  ByteRegister pPortC;

 public:

  Cvmio10 (const char *pBoardVmeAddress, int nVmioBay_in); /* Constructor; 
	  pBoardVmeAddress is VME address (not local) */

  int ResetCIO ();
  int InitPorts (Byte cPortA_invert, Byte cPortA_dir,
	         Byte cPortB_invert, Byte cPortB_dir,
	         Byte cPortC_invert, Byte cPortC_dir);
  int SetPortDirection (char cPortLetter, Byte cPortDir);

};

#endif /* __VMIO10_H__ */

