/* 
   vadc.h

   Mark Sibenac
   Lunar Rover Terrestrial Prototype
   Field Robotics Center
   97-1-9

   This is the header to the vadc interface.

   nVadcBay = (0->P5,P6,P9,P10;01-16,   1->P3,P4,P7,P8;17-32)

*/

#ifndef __VADC_H__
#define __VADC_H__

#include "common/nomad_global.h"
#include "../devices.h"

#define VADC_DATA_OFFSET (0x00)
#define VADC_SELECT_OFFSET (0x02)
#define VADC_RES12BIT_OFFSET (0x04)

const Word VADC_COMPLETE_MASK (0x1000);

class Cvadc : public Cdevices {
private:
  const double VOLT_PER_BIT = 0.0048828125; // (10 - (-10)) / 2^12

  WordRegister pSelectReg;
  WordRegister pDataReg;
  WordRegister pRes12BitReg;

  int nVadcBay; // {0..1}

protected:
  int nSingleDiff; // 0-Single-Ended, 1-Differential


public:
  /* Constructor: pBoardVmeAddress is VME address (not local) */
  Cvadc(const char *pBoardVmeAddress, int nVadcBay_in, int nSingleDiff_in); 

  int Init();

  int   GetADCI(int nChannel);
  double GetADCF(int nChannel);
};

#endif /* __VADC_H__ */   
