/*
   pid.h

   Mark Sibenac
   97-1-14
   Atacama Desert Trek
   Field Robotics Center

   This is a general PID controller.

*/

#ifndef __PID_H__
#define __PID_H__

#include "common/nomad_global.h"
#include "components/amps/amps.h"

class Cpid {
 private:

  // Parameters
  double fKp;
  double fKi;
  double fKd;
  double fI_limit;
  double fMaxPosErr;
  int    nDT; // Period

  // Servo Variables
  double fCurPos;
  double fLastPos;
  double fSumErr;
  double fDesPos;
  double fCommand;

  Camps  *m_amp; // pointer to the amp that is using this PID controller
  double GetPosition () {return m_amp->GetPosition();}

 protected:

 public:

  Cpid (Camps *amp);

  int    Reset ();
  double SetKp (double Kp) {fKp = Kp;}
  double GetKp ()          {return fKp;}
  double SetKi (double Ki) {fKi = Ki;}
  double GetKi ()          {return fKi;}
  double SetKd (double Kd) {fKd = Kd;}
  double GetKd ()          {return fKd;}
  double SetILimit (double Ilimit) {fI_limit = Ilimit;}
  double GetILimit ()      {return fI_limit;}
  double SetMaxPosErr (double MaxPosErr) {fMaxPosErr = MaxPosErr;}
  double GetMaxPosErr ()   {return fMaxPosErr;}
  int    SetDT (int DT)    {nDT = DT;}
  int    GetDT ()          {return nDT;}

  int    Init (double Kp, double Ki, double Kd, double I_limit, 
	       double MaxPosErr, int DT=1);
  int    ServoLaw(); // called at the update frequency

  double GetCommand ()     {return fCommand;}
  int    SetDesPos (double DesPos) {fDesPos = DesPos; return 0;}
  double GetDesPos () {return fDesPos;}
  double GetCurPos () {return fCurPos;}
};

#endif // __PID_H__
