/*
   test_gps.h

   Mark Sibenac
   97-2-6
   Atacama Desert Trek
   Field Robotics Center

   This tests the gpsoder interface.

*/

#ifndef __TEST_GPS_H__
#define __TEST_GPS_H__

#include "gps.h"

extern Cgps *gps;

extern "C" {
  double gps_Lat  ();
  double gps_Long  ();
  double gps_Height  ();
  double gps_X (); 
  double gps_Y (); 
  double gps_Z (); 
  double gps_DX ();
  double gps_DY ();
  double gps_DZ ();
  int gps_SVS ();

  void gps_Panel();
  void gps_Key();
  void gps_Seq(char *);

  int gps_Init ();
  void gps_Flush();
  int gps_Kill ();
  void gps_Config (unsigned char port, unsigned char type, unsigned char freq);
}

#endif // __TEST_GPS_H__
