/*
   test_gps.cxx

   Mark Sibenac
   97-2-6
   Atacama Desert Trek
   Field Robotics Center

   This tests the gps interface.

*/

#include <math.h>
#include "test_gps.h"
//#include "scopeprobe.h"
#include "taskLib.h"
#include "sysLib.h"
#include "usrLib.h"

Cgps *gps;

int gps_Init ()
{
  gps = new Cgps();
  gps->init("/tyCo/1");
//  sp((FUNCPTR)gps_Scope,20,2,3,4,5,6,7,8,9);
  return 0;
}

void gps_Flush() {
  gps->flushSerial();
  return;
}

double gps_Lat  ()
{
  double lat;

  gps->updateState();
  lat = gps->getLat();
  printf("Latitude = %f %s\n", fabs(lat), (lat > 0) ? "N" : "S");
  return lat;
}
double gps_Long  ()
{
  double dlong;

  gps->updateState();
  dlong = gps->getLong();
  printf("Longitude = %f %s\n", fabs(dlong), (dlong > 0) ? "E" : "W");
  return dlong;
}
double gps_Height  ()
{
  double height;

  gps->updateState();
  height = gps->getHeight();
  printf("Height = %f\n", height);
  return height;
}

double gps_X  ()
{
  double X;

  gps->updateState();
  X = gps->getX();
  printf("X = %f\n", X);
  return X;
}
double gps_Y  ()
{
  double Y;

  gps->updateState();
  Y = gps->getY();
  printf("Y = %f\n", Y);
  return Y;
}
double gps_Z  ()
{
  double Z;

  gps->updateState();
  Z = gps->getX();
  printf("Z = %f\n", Z);
  return Z;
}

double gps_DX  ()
{
  double dx;

  gps->updateState();
  dx = gps->getDX();
  printf("Delta X = %f\n", dx);
  return dx;
}
double gps_DY  ()
{
  double dy;

  gps->updateState();
  dy = gps->getDY();
  printf("Delta Y = %f\n", dy);
  return dy;
}
double gps_DZ  ()
{
  double dz;

  gps->updateState();
  dz = gps->getDZ();
  printf("Delta Z = %f\n", dz);
  return dz;
}

int gps_SVS  ()
{
  unsigned char svstot;

  gps->updateState();
  svstot = gps->getSVS();
  printf("Number of SVs = %d\n", svstot);
  return svstot;
}

void gps_Panel() {
  gps->showPanel();
  return;
}

void gps_Key() {
  gps->panelMode();
  return;
}

void gps_Seq(char *seq) {
  gps->keySequence(seq);
  return;
}

int gps_Kill ()
{
  delete gps;
  return 0;
}

void gps_Config(unsigned char port, unsigned char type, unsigned char freq) {
  gps->setMessage(port, type, freq);
}
