/* File: gpsUtil.h
 * Created by: Nick Vallidis
 * Creation date: 970115
 *
 * Description: header file for gps utility routines
 */

#ifndef _GPSUTIL_H_
#define _GPSUTIL_H_



/**********************************************************************
/* defines
/*********************************************************************/

/* commands from/to receiver */
#define ACK 0x06
#define NAK 0x15
#define ENQ 0x05
#define STX 0x02
#define ETX 0x03

/* Message types (for the type field of the GpsMessage structure */
#define MESSAGE_OK 0
#define MESSAGE_ERROR 1
#define MESSAGE_GETSERIAL 0x06
#define MESSAGE_RSERIAL 0x07
#define MESSAGE_GETSTAT1 0x08
#define MESSAGE_RECSTAT1 0x09
#define MESSAGE_GENOUT 0x40
#define MESSAGE_GETRAW 0x56
#define MESSAGE_RAWDATA 0x57
#define MESSAGE_KEYSIM 0x81
#define MESSAGE_SCRDUMP 0x82


/**********************************************************************
/* types
/*********************************************************************/

typedef struct GpsMessage {
  unsigned char type;
  unsigned char status;
  unsigned char length;
  unsigned char *pData;
} GpsMessage, *GpsMessagePtr, **GpsMessageHdl;


/**********************************************************************
/* Prototypes
/*********************************************************************/

/* see if the receiver is ready for commands
 * takes: fd for serial line
 * returns: zero - receiver ok
 *          non-zero - receiver busy
 */
int checkOperational(int serial_fd);

/* read a response from the serial line - wait for one if there isn't
 * already one there.
 * takes: fd for serial line
 * returns: pointer to the message
 */
GpsMessagePtr getResponse(int serial_fd);

/* send a command on the serial line 
 * takes: fd for serial line
 *        pointer to a valid message structure
 */
void sendCommand(int serial_fd, GpsMessagePtr pMessage);



#endif /* _GPSUTIL_H_ */
