/* File: gpsPrint.h
 * Created by: Nick Vallidis
 * Creation date: 970115
 *
 * Description: header file for message printing routines 
 */

#ifndef _GPSPRINT_H_
#define _GPSPRINT_H_



#include "gpsUtil.h"


/**********************************************************************
/* defines
/*********************************************************************/


/**********************************************************************
/* types
/*********************************************************************/


/**********************************************************************
/* Prototypes
/*********************************************************************/

/* print out the RSERIAL gps message
 * takes: pointer to GpsMessage where type = MESSAGE_RSERIAL
 */
void printRSERIAL(GpsMessagePtr pMessage);

/* print out the RECSTAT1 gps message
 * takes: pointer to GpsMessage where type = MESSAGE_RECSTAT1
 */
void printRECSTAT1(GpsMessagePtr pMessage);

/* print out the GENOUT gps message
 * takes: pointer to GpsMessage where type = MESSAGE_GENOUT
 */
void printGENOUT(GpsMessagePtr pMessage);

/* print out the RAWDATA gps message
 * takes: pointer to GpsMessage where type = MESSAGE_RAWDATA
 */
void printRAWDATA(GpsMessagePtr pMessage);

/* print out the KEYSIM gps message
 * takes: pointer to GpsMessage where type = MESSAGE_KEYSIM
 */
void printKEYSIM(GpsMessagePtr pMessage);

/* print out the SCRDUMP gps message
 * takes: pointer to GpsMessage where type = MESSAGE_SCRDUMP
 */
void printSCRDUMP(GpsMessagePtr pMessage);

/* print out any gps message
 * calls one of the above functions if message is that type
 * takes: pointer to GpsMessage where type = MESSAGE_RSERIAL
 */
void printMessage(GpsMessagePtr pMessage);



#endif /* _GPSPRINT_H_ */
