/* Created by: Nick Vallidis
 * Creation date: 970115
 *
 * Description: simple program to send commands to gps receiver. 
 */

#include <stdio.h>
#include <math.h>
#include "gpsPrint.h"



void printRSERIAL(GpsMessagePtr pMessage)
{
  char buf[10];

  if (pMessage->length != 0x2D)
    printf("There is not the correct amount of data to print this message.\n");
  else {
    strncpy(buf, pMessage->pData, 8);
    buf[8] = 0;
    printf("Receiver Serial #:   %s\n", buf);
    strncpy(buf, &(pMessage->pData)[8], 8);
    buf[8] = 0;
    printf("Receiver Type:       %s\n", buf);
    strncpy(buf, &(pMessage->pData)[16], 5);
    buf[5] = 0;
    printf("Nav Process Version: %s\n", buf);
    strncpy(buf, &(pMessage->pData)[21], 5);
    buf[5] = 0;
    printf("Sig Process Version: %s\n", buf);
    strncpy(buf, &(pMessage->pData)[26], 5);
    buf[5] = 0;
    printf("Boot ROM Version:    %s\n", buf);
    strncpy(buf, &(pMessage->pData)[31], 8);
    buf[8] = 0;
    printf("Antenna Serial #:    %s\n", buf);
    strncpy(buf, &(pMessage->pData)[39], 2);
    buf[2] = 0;
    printf("Antenna Type:        %s\n", buf);
    strncpy(buf, &(pMessage->pData)[41], 2);
    buf[2] = 0;
    printf("# Channels:          %s\n", buf);
    strncpy(buf, &(pMessage->pData)[43], 2);
    buf[2] = 0;
    printf("# Channels L1:       %s\n", buf);
  }
}


void printRECSTAT1(GpsMessagePtr pMessage)
{
  char buf[10];
  if (pMessage->length != 0x15)
    printf("There is not the correct amount of data to print this message.\n");
  else {
    strncpy(buf, pMessage->pData, 1);
    buf[1] = 0;
    printf("Position Fix:        %s\n", buf);
    strncpy(buf, &(pMessage->pData)[1], 1);
    buf[1] = 0;
    printf("Measurement Status:  %s\n", buf);
    strncpy(buf, &(pMessage->pData)[2], 2);
    buf[2] = 0;
    printf("# SVs Locked:        %s\n", buf);
    strncpy(buf, &(pMessage->pData)[4], 3);
    buf[3] = 0;
    printf("Meas To Go:          %s\n", buf);
    strncpy(buf, &(pMessage->pData)[7], 3);
    buf[3] = 0;
    printf("% Battery Remaining: %s\n", buf);
    strncpy(buf, &(pMessage->pData)[10], 4);
    buf[4] = 0;
    printf("Dec Hours of Mem:    %s\n", buf);
    strncpy(buf, &(pMessage->pData)[14], 1);
    buf[1] = 0;
    printf("Status of Survey:    %s\n", buf);
    strncpy(buf, &(pMessage->pData)[15], 4);
    buf[4] = 0;
    printf("Status of Receiver:  %s\n", buf);
    strncpy(buf, &(pMessage->pData)[19], 2);
    buf[2] = 0;
    printf("# L2 Channels Oper:  %s\n", buf);
  }
}


void printGENOUT(GpsMessagePtr pMessage)
{
  double dX,dY,dZ;
  int i;

  if (pMessage->pData[3] != 6) { /* if not XYZ delta data */
    printf("Not a known data type.\n");
  } else {
    for (i=0; i<8; i++)
      ((unsigned char *)&dX)[i] = pMessage->pData[5+i];
    for (i=0; i<8; i++)
      ((unsigned char *)&dY)[i] = pMessage->pData[13+i];
    for (i=0; i<8; i++)
      ((unsigned char *)&dZ)[i] = pMessage->pData[21+i];
    printf("Delta X: %f\n",dX);
    printf("Delta Y: %f\n",dY);
    printf("Delta Z: %f\n",dZ);
  }
}

    
void printRAWDATA(GpsMessagePtr pMessage)
{
  int i;
  unsigned char crap[8];
  double latitude, longitude;

  printf("Record type: %d\n", (pMessage->pData)[0]);
  printf("PageCounter: 0x%x\n", (pMessage->pData)[1]);
  printf("Reply #:     0x%x\n", (pMessage->pData)[2]);
  printf("Record interp flags: 0x%x\n", (pMessage->pData)[3]);
  for(i=0; i<8; i++)
    ((unsigned char *)&latitude)[i] = pMessage->pData[4+i];
  for(i=0; i<8; i++)
    ((unsigned char *)&longitude)[i] = pMessage->pData[12+i];
  printf("Latitude:    %lf", fabs(latitude * 180.0));
  if (latitude > 0)
    printf(" N\n");
  else
    printf(" S\n");
  printf("Longitude:   %lf", fabs(longitude * 180.0));
  if (longitude > 0)
    printf(" E\n");
  else
    printf(" W\n");
  printf("Altitude:    %lf\n",*((double *) &(pMessage->pData[20])));

}


void printKEYSIM(GpsMessagePtr pMessage)
{
  printf("Key Pressed: 0x%x\n",*(pMessage->pData));
}


void printSCRDUMP(GpsMessagePtr pMessage)
{
  char buf[50];
  buf[40] = 0;

  if (pMessage->length != 0) {
    strncpy(buf, pMessage->pData, 40);
    printf("1: %s\n", buf);
    strncpy(buf, pMessage->pData+40, 40);
    printf("2: %s\n", buf);
    strncpy(buf, pMessage->pData+80, 40);
    printf("3: %s\n", buf);
    strncpy(buf, pMessage->pData+120, 40);
    printf("4: %s\n", buf);
    printf("Cursor Position: %d\n",(unsigned char)(pMessage->pData[160]));
  } else {
    printf("Request only, no data included \n");
  }
}


void printMessage(GpsMessagePtr pMessage)
{
  printf("\nYour message says:\n");
  switch(pMessage->type) {
    case MESSAGE_OK: printf("Acknowledge\n"); break;
    case MESSAGE_ERROR: printf("Error\n"); break;
    case MESSAGE_GETSERIAL: printf("Get Receiver & Antenna Serial Information\n");
                            break;
    case MESSAGE_RSERIAL: printf("Receiver & Antenna Information\n");
                          printRSERIAL(pMessage); break;
    case MESSAGE_GETSTAT1: printf("Get Receiver Status, Variable\n"); break;
    case MESSAGE_RECSTAT1: printf("Receiver Status, Variable\n");
                           printRECSTAT1(pMessage); break;
    case MESSAGE_GENOUT: printf("General Output Record\n");
                         printGENOUT(pMessage); break;
    case MESSAGE_GETRAW: printf("Request Position or Real-Time Survey Data\n");
                         break;
    case MESSAGE_RAWDATA: printf("Real-Time Seurvey Data\n"); 
                          printRAWDATA(pMessage); break;
    case MESSAGE_KEYSIM: printf("Simulate Front Panel Keypress\n");
                         printKEYSIM(pMessage); break;
    case MESSAGE_SCRDUMP: printf("Front Panel Screen Dump\n");
                          printSCRDUMP(pMessage); break;
    default: printf("Unknown Message. Please hang up and try again.\n");
             printf("If you need help, hang up and then dial your operator.\n");
             printf("Message #: 0x%x\n",pMessage->type);
  }
  printf("\n");
}
