/* Created by: Nick Vallidis
 * Creation date: 970115
 *
 * Description: simple program to send commands to gps receiver. 
 */

#include <stdlib.h>
#include <stdio.h>
#include "serialRS232.h"
#include "gpsUtil.h"
#include "gpsPrint.h"



int gSerial_fd;



void sendGETRAW(GpsMessagePtr pMessage)
{
  pMessage->pData = malloc(3);
  pMessage->length = 3;
  pMessage->pData[0] = 1; /* get position record */
  pMessage->pData[1] = 0;
  pMessage->pData[2] = 0;
  sendCommand(gSerial_fd, pMessage);
  free(pMessage->pData);
}


void panelMode()
{
  GpsMessage command;
  GpsMessagePtr pResponse;
  char key;

  for(key=0; key!='Q'; key=getchar()) {
    command.type = MESSAGE_SCRDUMP;
    command.length = 0;
    sendCommand(gSerial_fd, &command);
    pResponse = getResponse(gSerial_fd);
    printMessage(pResponse);
    if (key == 0x0D)
      continue;
    switch(key) {
      case ',':
      case '<': key = 0x1D; break;
      case '.':
      case '>': key = 0x1C; break;
      case ';': key = 0x7F; break;
      case '/': key = 0x0D; break;
      case 'z': 
      case 'Z': key = 0x1B; break;
      default: break;
    }
    command.type = MESSAGE_KEYSIM;
    command.length = 1;
    command.pData = &key;
    sendCommand(gSerial_fd, &command);
    pResponse = getResponse(gSerial_fd);
    printMessage(pResponse);
  }
  serialFlushBuffer(gSerial_fd);
}


main()
{
  char b=0;
  GpsMessage command;
  GpsMessagePtr pResponse;

  printf("GPS Receiver Control Program.\n");
  
  /* set up the serial port */
  gSerial_fd = serialInit("/dev/ttya", 9600, parity_NONE);


  if (checkOperational(gSerial_fd)) {
    printf("GPS receiver is not ready to accept commands.\n");
    printf("Please check connections and power and try again.\n");
    exit(-1);
  }

  /* ok, receiver is ready so let's go. */
  while(b != 'Q') {
    printf("\nHere are your options:\n");
    printf("  (1) Get Receiver and Antenna Serial Information\n");
    printf("  (2) Get Receiver Status, Variable\n");
    printf("  (3) Request Position or Real-Time Survey Data\n");
    printf("\n");
    printf("  (4) Enter Front Panel Mode\n");
    printf("  (5) Read current message on serial port\n");
    printf("  (6) Continuously read serial messages\n");
    printf("  (7) Flush Serial Buffer\n");
    printf("\n  (Q)uit\n");
    do {
      b = toupper(getchar());
    } while (!isalnum(b));

    switch(b) {
      case '1': command.type = MESSAGE_GETSERIAL;
                command.length = 0;
                sendCommand(gSerial_fd, &command); break;
      case '2': command.type = MESSAGE_GETSTAT1;
                command.length = 0;
                sendCommand(gSerial_fd, &command); break;
      case '3': command.type = MESSAGE_GETRAW;
                sendGETRAW(&command); break;
      case '4': panelMode(); break;
      case '5': pResponse = getResponse(gSerial_fd);
                printMessage(pResponse); break;
      case '6': while (1) {
	          pResponse = getResponse(gSerial_fd);
		  printMessage(pResponse);
		} break;
      case '7': serialFlushBuffer(gSerial_fd); break;
      default: break;
    }
    if ((b >= '1') && (b <= '3')) {
      pResponse = getResponse(gSerial_fd);
      printMessage(pResponse);
    }
  }

  /* close the serial port */
  close(gSerial_fd);
}
