package nomadgui.tools;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/** This class allows setText() to be called on an extension of
  * JLabel without calling it directly.  Updating a component
  * outside of the event queue is not thread safe. This should
  * be used with SwingUtilities.invokeLater(Runnable r)
  */

public class runnableText implements Runnable {
  private String message;
  private JLabel label;
  private JTextField field;
  private boolean isLabel;

  /** Creates a new runnableText object with the specified message and JLabel.
    * @param m The message to be set.
    * @param a The JLabel this message is associated with.
    */
  
  public runnableText(String m, JLabel a) {
    message = m;
    label = a;
    isLabel = true;
  }

  /** Creates a new runnableText object with the specified message and
    * JTextField.
    * @param m The message to be set.
    * @param a The JTextField this message is associated with.
    */
  
  public runnableText(String m, JTextField a) {
    message = m;
    field = a;
    isLabel = false;
  }

  /** Sets the text of the JLabel (or JTextField) to the current message.
    * This class is intended to be used with
    * SwingUtilities.invokeLater(Runnable r), so the text
    * will be set on the event queue for thread safety.
    * @return None.
    */
  
  public void run() {
    if (isLabel) label.setText(message);
    else field.setText(message);
  }
}
