package nomadgui.state;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import nomadgui.tools.*;

class SpeedPanel extends JPanel {
  JLabel labelSpeed, labelTop, labelCenter, labelBottom, labelNumber;
  SpeedBar speedBar;

  volatile private int speed = 0;
  volatile private boolean negative = false;

  SpeedPanel() {
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();

    setPreferredSize(new Dimension(180,120));
    setLayout(gridbag);
    setBorder(BorderFactory.createTitledBorder("Speed"));

    c.anchor = GridBagConstraints.SOUTHEAST;
    
    c.gridwidth = 1; c.gridheight = 1;
    c.gridx = 0; c.gridy = 0;
    labelTop = new JLabel("50");
    gridbag.setConstraints(labelTop, c);
    add(labelTop);

    c.gridwidth = 1; c.gridheight = 1;
    c.gridx = 0; c.gridy = 1;
    labelCenter = new JLabel("0");
    labelCenter.setPreferredSize(new Dimension(20,64));
    labelCenter.setHorizontalAlignment(JLabel.RIGHT);
    gridbag.setConstraints(labelCenter, c);
    add(labelCenter);

    c.gridwidth = 1; c.gridheight = 1;
    c.gridx = 0; c.gridy = 2;
    labelBottom = new JLabel("-50");
    gridbag.setConstraints(labelBottom, c);
    add(labelBottom);

    c.anchor = GridBagConstraints.NORTH;

    c.gridwidth = 1; c.gridheight = 3;
    c.gridx = 1; c.gridy = 0;
    speedBar = new SpeedBar();
    gridbag.setConstraints(speedBar, c);
    add(speedBar);

    c.anchor = GridBagConstraints.CENTER;
    c.gridwidth = 1; c.gridheight = 3;
    c.gridx = 2; c.gridy = 0;
    labelNumber = new JLabel("0.0 cm/s");
    labelNumber.setPreferredSize(new Dimension(80,20));
    labelNumber.setBorder(BorderFactory.createLoweredBevelBorder());
    labelNumber.setVerticalAlignment(JLabel.CENTER);
    gridbag.setConstraints(labelNumber, c);
    add(labelNumber);
  }

  synchronized void setSpeed(int s) {
    speed = s;
    if (negative) speed = -speed;
    runnableText t = new runnableText(speed+" cm/s", labelNumber);
    SwingUtilities.invokeLater(t);
    speedBar.setSpeed(speed);
    repaint();
  }
  synchronized void setNegative(boolean neg) { negative = neg; }
  
}

class SpeedBar extends JPanel {
  volatile int speed = 0;

  SpeedBar() {
    setPreferredSize(new Dimension(60,90));
  }

  synchronized void setSpeed(int s) { speed = s; }  

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2 = (Graphics2D) g;

    setOpaque(true);

    if(speed < 0) {
      g2.setColor(Color.green);
      g2.fill(new Rectangle2D.Double(10, 45, 40, -(4.0/5.0)*speed));
    }
      
    if(speed > 0) {
      g2.setColor(Color.blue);
      g2.fill(new Rectangle2D.Double(10, 45-(4.0/5.0)*speed, 40,
				     (4.0/5.0)*speed));
    }

    g2.setColor(Color.black);
    g2.draw(new Line2D.Double(10, 45, 50, 45));
    g2.setStroke(new BasicStroke(2.0f));
    g2.draw(new Rectangle2D.Double(10, 5, 40, 80));
  }
  
}
