package nomadgui.state;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import nomadgui.tools.*;

class HeadingPanel extends JPanel {
  JLabel labelNumber, labelDir;
  CompassPanel compassPanel;
  JPanel box;

  volatile private float heading = 0.0f;

  HeadingPanel() {
    GridBagLayout gridbag = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();

    setPreferredSize(new Dimension(180,120));

    setLayout(gridbag);

    setBorder(BorderFactory.createTitledBorder("Heading"));
    
    c.gridwidth = 1; c.gridheight = 1;
    c.gridx = 0; c.gridy = 0;
    compassPanel = new CompassPanel();
    gridbag.setConstraints(compassPanel, c);
    add(compassPanel);

    c.anchor = GridBagConstraints.CENTER;
    c.gridwidth = 1; c.gridheight = 1;
    c.gridx = 1; c.gridy = 0;
    box = new JPanel(new GridLayout(2,1));
    box.setPreferredSize(new Dimension(70,50));
    box.setBorder(BorderFactory.createLoweredBevelBorder());
    gridbag.setConstraints(box, c);
    add(box);

    
    labelNumber = new JLabel("0.0");
    labelNumber.setPreferredSize(new Dimension(70,20));
    labelNumber.setHorizontalAlignment(JLabel.CENTER);
    box.add(labelNumber);

    labelDir = new JLabel("N");
    labelDir.setPreferredSize(new Dimension(70,20));
    labelDir.setHorizontalAlignment(JLabel.CENTER);
    box.add(labelDir);
  }

  synchronized void setHeading(int h) {
    heading = (float)Math.toDegrees(((float)h)/100.0f);
    String labelText;

    compassPanel.setHeading(heading);
    
    // change based on heading input method...
    
    if(heading == 0 || heading == 360) {
      labelText = "N";
      heading = 0;
    } else if (heading == 180) {
      labelText = "S";
      heading = 0;
    } else if (heading == 90) {
      labelText = "E";
      heading = 0;
    } else if (heading == 270) {
      labelText = "W";
      heading = 0;
    } else if (heading < 90) {
      labelText = "E of N";
    } else if (heading < 180) {
      labelText = "E of S";
      heading = 180 - heading;
    } else if (heading < 270) {
      labelText = "W of S";
      heading = heading - 180;
    } else {
      labelText = "W of N";
      heading = 360 - heading;
    }

    runnableText t1 = new runnableText(labelText, labelDir);
    SwingUtilities.invokeLater(t1);
    
    runnableText t2 = new runnableText(Float.toString(Format.round(heading,1)),
				       labelNumber);
    SwingUtilities.invokeLater(t2);

    repaint();
  }
}

