package nomadgui.state;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import nomadgui.tools.*;

class CompassPanel extends JPanel {
  volatile float heading = 0.0f;
  Point2D.Float origin = new Point2D.Float(50, 40);
  Point2D.Float end = new Point2D.Float(50, 15);

  CompassPanel() {
    setPreferredSize(new Dimension(100,90));
  }

  synchronized void setHeading(float h) {
    heading =(h);
  }

  public void paintComponent(Graphics g) {
    super.paintComponent(g);
    Graphics2D g2 = (Graphics2D) g;

    setOpaque(true);

    g2.setColor(Color.white);
    g2.fill(new Ellipse2D.Float(20, 10, 60, 60));
      
    g2.setColor(Color.black);

    g2.drawString("N", 46, 8);
    g2.drawString("S", 47, 83);
    g2.drawString("W", 8, 45);
    g2.drawString("E", 83, 45);
    
    g2.draw(new Line2D.Float(20, 40, 80, 40));
    g2.draw(new Line2D.Float(50, 10, 50, 70));
    g2.setStroke(new BasicStroke(2.0f));
    g2.draw(new Ellipse2D.Float(20, 10, 60, 60));

    g2.setColor(Color.blue);
    g2.setStroke(new BasicStroke(3.0f));
    AffineTransform at =
      AffineTransform.getRotateInstance(Math.toRadians(heading), origin.x,
					origin.y);
    g2.transform(at);
    g2.draw(new Line2D.Float(origin, end));
  }
  
}
