package nomadgui;

import nomadgui.state.*;

class fovTestThread extends Thread {
  RSPFrame rframe;
  final float ff = (float)Math.PI/4;     // forty-five degrees
  final float tf = (float)Math.PI*5/36;  // twenty-five degrees

  fovTestThread(RSPFrame r) {
    rframe = r;
  }

  public void run() {
    // Move field from 25 -> ~0 -> 25
    for (float x=tf; x>0; x-=.01) {
      rframe.setFOV(0,0,x);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    for (float x=1; x<tf; x+=.01) {
      rframe.setFOV(0,0,x);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }
    
    // Move tilt from 0 -> 60, pan 360 degrees, then tilt from 60 -> -60 -> 0
    for (float x=0; x<ff*4/3; x+=.01) {
      rframe.setFOV(0,x,tf);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    for (float x=0; x<2*Math.PI; x+=.01) {
      rframe.setFOV(x,ff*4/3,tf);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    for (float x=ff*4/3; x>-ff*4/3; x-=.01) {
      rframe.setFOV(0,x,tf);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    for (float x=-ff*4/3; x<0; x+=.01) {
      rframe.setFOV(0,x,tf);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    rframe.setFOV(0,0,tf);
  }
}
