package nomadgui.control;

import javax.swing.*;
import java.awt.*;

/** A simple extension of JTabbedPane that sets up the tabs in the
  * Robot Control Panel.  There are four tabs, called Manual, Independent,
  * Map, and Sensors.
  * @see nomad.control.IndependentPanel
  */

public class controlTabbedPane extends JTabbedPane {
  JPanel map, sensor;
  ManualPanel manual;
  IndependentPanel indep;

  /** Default Constructor.  The tabs are placed on the left side
    * of the pane.
    */

  controlTabbedPane() { this(JTabbedPane.LEFT); }

  /** Allows choice of tab position.  The tab location is specified by one of
    * JTabbedPane.LEFT, JTabbedPane.RIGHT, JTabbedPane.TOP, or
    * JTabbedPane.BOTTOM.
    * @param side Specifies the side of the pane where the tabs appear.
    */
  
  controlTabbedPane(int side) {
    super(side);
    manual = new ManualPanel();
    indep = new IndependentPanel();
    map = new JPanel();
    sensor = new JPanel();
    
    addTab("Manual", null, manual, "Manual Control");
    addTab("Independent", null, indep, "Independent Control");
    addTab("Map", null, map, "Overhead Map View");
    addTab("Sensors", null, sensor, "Sensor/Arm Control");
  }
}
