import state.*;

class fovTestThread extends Thread {
  RSPFrame rframe;
  final double ff = (Math.PI/4)*100;     // forty-five degrees
  final double tf = (Math.PI*5/36)*100;  // twenty-five degrees

  fovTestThread(RSPFrame r) {
    rframe = r;
  }

  public void run() {
    // Move field from 25 -> ~0 -> 25
    for (double x=tf; x>0; x-=1) {
      rframe.setFOV(0,0,x);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    for (double x=1; x<tf; x+=1) {
      rframe.setFOV(0,0,x);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }
    
    // Move tilt from 0 -> 60, pan 360 degrees, then tilt from 60 -> -60 -> 0
    for (double x=0; x<ff*4/3; x+=1) {
      rframe.setFOV(0,x,tf);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    for (double x=0; x<200*Math.PI; x+=1) {
      rframe.setFOV(x,ff*4/3,tf);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    for (double x=ff*4/3; x>-ff*4/3; x-=1) {
      rframe.setFOV(0,x,tf);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    for (double x=-ff*4/3; x<0; x+=1) {
      rframe.setFOV(0,x,tf);
      try { Thread.sleep(10); } catch(InterruptedException ie) {}
    }

    rframe.setFOV(0,0,tf);
  }
}
