import javax.swing.*;
import nddsJava.*;
import Telemetry.*;
import Science.*;
import Realtime.*;
import java.util.*;
import tools.*;

class NomadGUI {
  public static void main(String args[]) {
    Config.initialize();
    nddsTelemetryThread telThread;
    //updateThread ut;
    
    boolean connect = false;
    if (args.length == 2) {
      connect = true;
      System.out.println("Attempting to connect to "+args[0]+
			 ", port "+args[1]+"...");
    } else if (args.length == 0) {
      connect = false;
      System.out.println("Starting in test mode (no server connection)...");
    } else {
      System.err.println("USAGE: java NomadGUI [serverIP serverPort]");
      System.exit(-1);
    }
    
    NomadFrame window = new NomadFrame("Nomad User Interface");
    window.setVisible(true);
    //ut = new updateThread(window);
    //ut.start();

    if (connect) {
      Vector v = new Vector();

      // Declare NDDS messages here, add them into the vector.
      bodDerivedState bodDerivedStateMsg = new bodDerivedState();
      v.add(new nddsMsg(bodDerivedStateMsg, nddsMsg.BOD_DERIVED_STATE_MSG_NAME,
			nddsMsg.PUBLISH_SUBSCRIBE,
			new bodDerivedStateCallback(bodDerivedStateMsg),
			window));
      posDerivedState posDerivedStateMsg = new posDerivedState();
      v.add(new nddsMsg(posDerivedStateMsg, nddsMsg.POS_DERIVED_STATE_MSG_NAME,
			nddsMsg.PUBLISH_SUBSCRIBE,
			new posDerivedStateCallback(posDerivedStateMsg),
			window));
      kvhDerivedState kvhDerivedStateMsg = new kvhDerivedState();
      v.add(new nddsMsg(kvhDerivedStateMsg, nddsMsg.KVH_DERIVED_STATE_MSG_NAME,
			nddsMsg.PUBLISH_SUBSCRIBE,
			new kvhDerivedStateCallback(kvhDerivedStateMsg),
			window));
      weatherState weatherStateMsg = new weatherState();
      v.add(new nddsMsg(weatherStateMsg, nddsMsg.WEATHER_STATE_MSG_NAME,
			nddsMsg.PUBLISH_SUBSCRIBE,
			new weatherStateCallback(weatherStateMsg),
			window));
      rtAmpState rtAmpStateMsg = new rtAmpState();
      v.add(new nddsMsg(rtAmpStateMsg, nddsMsg.RT_AMP_STATE_MSG_NAME,
			nddsMsg.PUBLISH_SUBSCRIBE,
			new rtAmpStateCallback(rtAmpStateMsg),
			window));
      rtControlState rtControlStateMsg = new rtControlState();
      v.add(new nddsMsg(rtControlStateMsg, nddsMsg.RT_CONTROL_STATE_MSG_NAME,
			nddsMsg.PUBLISH_SUBSCRIBE,
			new rtControlStateCallback(rtControlStateMsg),
			window));
      
      telThread = new nddsTelemetryThread(v);
      window.setNdds(telThread);
      telThread.connect(args[0], Integer.parseInt(args[1]));
      telThread.start();
    }

  }
}
