#include <fcntl.h>
#include <asm/ioctl.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <unistd.h>

#include "nicts.h"

int main(int argc, char *argv[])
{
  int daq,nr,nrtot,i;
  short valin[100000];

  int nscans=12, nch=4; 

  if(argc<2){printf("usage !\n"); return 1;}
  if((daq=open(argv[1],O_RDWR))<0){
    perror("cant open that file"); exit(1);}

    nrtot=0;

    ioctl(daq, NICTL_AI_RESET, 0);

    if(nch>3) ioctl(daq, NICTL_AI_ADDCH, 0x10000000);
    if(nch>2) ioctl(daq, NICTL_AI_ADDCH, 0x10010000);
    if(nch>1) ioctl(daq, NICTL_AI_ADDCH, 0x10020000);
    ioctl          (daq, NICTL_AI_ADDCH, 0x10038000);

    ioctl(daq, NICTL_AI_SET_SC, nscans-1);
    ioctl(daq, NICTL_AI_SET_SI, 10000-1); /* 1 ms */
    ioctl(daq, NICTL_AI_SET_SI2,400-1); /* 0.2 mss */

    ioctl(daq, NICTL_AI_SCAN_SETUP, 0);
    ioctl(daq, NICTL_AI_SCAN_START, 0);
    
    i=0;
    do{
      if((nr=read(daq,valin +nrtot/2 ,nscans*2*nch))<0){
	perror("cant read nidaq"); exit(2);}
      i++; if(nr>0)i=0;
      nrtot+=nr;
    } while(nrtot/2<nscans*nch && i<10000);
    printf("TOTAL bytes read: %d ",nrtot/2);

    for(i=0;i<16 && i<nrtot/2;i++)printf("%4d ",valin[i]); printf("\n");
    
  }

  close(daq);

  return 0;
}










