#include <dlfcn.h>
#include <asm/types.h>

#include "nicts.h"
#include "extcode.h"

void *nilib;
int (*LxDioWrite)(__s32 fh, __u16 port, __u32 wr_data, __u32 wr_mask);
 
 

CIN MgErr CINLoad (RsrcFile reserved)
{
  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);
  if(!nilib)return -1;
  LxDioWrite=dlsym(nilib, "LxDioWrite"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{
  dlclose(nilib);
  return noErr;
}

CIN MgErr CINRun(uInt16 *port, uInt32 *wr_data, uInt32 *wr_mask, int32 *ti_in, int32 *status)
{
  int dio_handle=*ti_in;

  if((*status=(*LxDioWrite)(dio_handle, *port, *wr_data, *wr_mask))<0)
     return noErr;

  *status=0; return noErr;
}






