#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

/*
 * typedefs
 */

typedef struct {
	int32 dimSize;
	uInt16 chan_no[1];
	} TD1;
typedef TD1 **TD1Hdl;

typedef struct {
	int32 dimSize;
	float32 arg1[1];
	} TD2;
typedef TD2 **TD2Hdl;

CIN MgErr CINRun(int16 *device, TD1Hdl channels, TD2Hdl values, int32 *status);

void *nilib;
int (*LxAoOpen)(__u16 device);
int (*LxAoCloseAll)();
int (*LxAoUpdateChannel)(__s32 fh, __u16 channel, double voltage);

CIN MgErr CINLoad (RsrcFile reserved)
{

  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxAoOpen=dlsym(nilib, "LxAoOpen"); if(dlerror()!=NULL)return -1;
  LxAoCloseAll=dlsym(nilib, "LxAoCloseAll"); if(dlerror()!=NULL)return -1;
  LxAoUpdateChannel=dlsym(nilib, "LxAoUpdateChannel"); if(dlerror()!=NULL)return -1;

  return noErr;
}

CIN MgErr CINUnload ()
{
  if(nilib){(*LxAoCloseAll)();dlclose(nilib);}
  return noErr;
}

CIN MgErr CINRun(int16 *device, TD1Hdl channels, TD2Hdl values, int32 *status) {
  int i, fh;
  float32 volt; int16 valbin;

  if((*status=fh=(*LxAoOpen)(*device))<0) return noErr;

  for(i=0; i<(*channels)->dimSize; i++){
    volt=i<(*values)->dimSize?(*values)->arg1[i]:0.0;
    if((*status=(*LxAoUpdateChannel)(fh, (*channels)->chan_no[i], volt))<0)
      return noErr;
  }
  *status=0; return noErr;
}
