#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

CIN MgErr CINRun(int32 *task_id_in, float64 *scan_freq, float64 *sample_freq, int32 *status);
void *nilib;
int (*LxAiTimeConfig)(__s32 fh, double scan_freq, double spl_freq, 
		   double *act_scan_freq, double *act_spl_freq);

CIN MgErr CINLoad (RsrcFile reserved)
{
  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxAiTimeConfig=dlsym(nilib, "LxAiTimeConfig"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{
  if(nilib)dlclose(nilib);
  return noErr;
}

CIN MgErr CINRun(int32 *task_id_in, float64 *scan_freq, float64 *sample_freq, int32 *status) {
  int fh;
  fh=*task_id_in;
  if((*status=(*LxAiTimeConfig)(fh, *scan_freq, *sample_freq,
				scan_freq, sample_freq))<0) return noErr;
  *status=0;return noErr;
}



