#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

/*
 * typedefs
 */

typedef struct {
	int32 dimSize;
	uInt16 chan_no[1];
	} TD1;
typedef TD1 **TD1Hdl;

typedef struct {
	float32 high;
	float32 low;
	} TD3;

typedef struct {
	int32 dimSize;
	TD3 limits[1];
	} TD2;
typedef TD2 **TD2Hdl;

typedef struct {
	uInt16 Uni_Bi_Polar;
	uInt16 Gain;
	} TD5;

typedef struct {
	int32 dimSize;
	TD5 configuration[1];
	} TD4;
typedef TD4 **TD4Hdl;

typedef struct {
	uInt16 Reference;
	} TD7;

typedef struct {
	int32 dimSize;
	TD7 settings[1];
	} TD6;
typedef TD6 **TD6Hdl;

CIN MgErr CINRun(int16 *device, TD1Hdl channels, TD2Hdl limits, TD4Hdl alt_limits, TD6Hdl settings, int32 *var6, int32 *status);

void *nilib;
int (*LxAiOpen)(__u16 device);
int (*LxAiCloseAll)();
int (*LxAiBoardConfig)(__s32 fh, __u16 nch, __u16 channels[], __u16 gains[],
		    __u16 polars[], __u16 refers[]);

CIN MgErr CINLoad (RsrcFile reserved)
{

  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxAiOpen=dlsym(nilib, "LxAiOpen"); if(dlerror()!=NULL)return -1;
  LxAiCloseAll=dlsym(nilib, "LxAiCloseAll"); if(dlerror()!=NULL)return -1;
  LxAiBoardConfig=dlsym(nilib, "LxAiBoardConfig");if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{

  if(nilib){(*LxAiCloseAll)(); dlclose(nilib);}
  return noErr;
}

static void range2gain(float32 hi, float32 lo, uInt16 *gain, uInt16* pol)
{
  float32 abs_limit, abs_range;
  float32 gains[8]={0.5, 1, 2, 5, 10, 20, 50, 100};

  if (lo>=0) {*pol=1; abs_range=10;} else /* range = 0 .. 10V */
    {*pol=0; abs_range=5;} /* range = -5V .. +5V */
  
  if(hi<0)hi=-hi; if(lo<0)lo=-lo;
  abs_limit=lo<hi?hi:lo;

  for(*gain=7;*gain; (*gain)--)
    if(abs_limit*gains[*gain] < abs_range) break;
}

CIN MgErr CINRun(int16 *device, TD1Hdl channels, TD2Hdl limits, TD4Hdl alt_limits, TD6Hdl settings, int32 *task_id, int32 *status) {
  int i, lasti, fh, nch;
  uInt16 gains[NI_MAX_AICH], polars[NI_MAX_AICH], refers[NI_MAX_AICH];
  
  if((*status=fh=(*LxAiOpen)(*device))<0)return noErr;
  *task_id=fh;

  nch=(*channels)->dimSize; if(nch>NI_MAX_AICH){*status=-10000; return noErr;}

  lasti=-1;
  if((*limits)->dimSize >0) for(i=0;i<nch;i++){ /* use high & low limits */
    if(i<(*limits)->dimSize)lasti=i;
    range2gain((*limits)->limits[lasti].high, (*limits)->limits[lasti].low,
	       &gains[i], &polars[i]);
  } else for(i=0;i<nch;i++){ /* use explicit gain & polarity */
    if(i<(*alt_limits)->dimSize)lasti=i;
    gains[i]= lasti>=0?(*alt_limits)->configuration[lasti].Gain:0;
    polars[i]=lasti>=0?(*alt_limits)->configuration[lasti].Uni_Bi_Polar:0;
  }

  lasti=-1;
  for(i=0;i<nch;i++){
    if(i<(*settings)->dimSize)lasti=i;
    refers[i]=lasti>=0?(*settings)->settings[lasti].Reference:0; 
  }

  (*LxAiBoardConfig)(fh, nch, (*channels)->chan_no, gains, polars, refers);

  *status=0;
  return noErr;
}

