#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

CIN MgErr CINRun(int16 *function, uInt32 *result, int32 *tid_in, int32 *status);
void *nilib;
int (*LxGpctWatch)(__s32 fh, __s16 function, __u32 *result);

CIN MgErr CINLoad (RsrcFile reserved)
{
  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxGpctWatch=dlsym(nilib, "LxGpctWatch"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{
  if(nilib)dlclose(nilib);
  return noErr;
}

CIN MgErr CINRun(int16 *function, uInt32 *result, int32 *tid_in, int32 *status) {
  int fh=*tid_in;
  if((*status=(*LxGpctWatch)(fh, *function, result))<0) return noErr;
 
  *status=0;
  return noErr;
}
