#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

CIN MgErr CINRun(int16 *function, int32 *tid_in, int32 *status);
void *nilib;
int (*LxGpctSetapp)(__s32 fh, __s16 function);

CIN MgErr CINLoad (RsrcFile reserved)
{
  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxGpctSetapp=dlsym(nilib, "LxGpctSetapp"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{
  if(nilib)dlclose(nilib);
  return noErr;
}

CIN MgErr CINRun(int16 *function, int32 *tid_in, int32 *status) {
  int fh=*tid_in;

  if((*status=(*LxGpctSetapp)(fh, *function))<0) return noErr;
  return noErr;
}






