#ifndef _NIDAQ_H
#define _NIDAQ_H 1

#include <asm/types.h>

int LxAiOpen(__u16 device);
int LxAiCloseAll(void);
int LxAiScale(__s32 fh, __u32 nscans, __s16 rddata[], float voltages[]);
int LxAiBoardConfig(__s32 fh, __u16 nch, __u16 channels[], __u16 gains[],
		    __u16 polars[], __u16 refers[]);
int LxAiStart(__s32 fh, __s32 no_of_scans);
int LxAiGetnch(__s32 fh);
int LxAiRead(__s32 fh, __s32 no_scans, __s16 buff[], __s32 *scans_read);
int LxAiClear(__s32 fh);
int LxAiTimeConfig(__s32 fh, double scan_freq, double spl_freq, 
		   double *act_scan_freq, double *act_spl_freq);
int LxAiSingleScan(__s32 fh, __s16 buff[]);

int LxAoOpen(__u16 device);
int LxAoCloseAll(void);
int LxAoUpdateChannel(__s32 fh, __u16 channel, double voltage);

int LxDioOpen(__u16 device);
int LxDioCloseAll(void);
int LxDioConfPort(__s32 fh, __u16 port, __u32 rw_mask);
int LxDioWrite(__s32 fh, __u16 port, __u32 wr_data, __u32 wr_mask);
int LxDioRead(__s32 fh, __u16 port, __u32 *read_data);

int LxGpctOpen(__u16 device, __u16 counter_no);
int LxGpctCloseAll(void);
int LxGpctSetapp(__s32 fh, __s16 function);
int LxGpctSetpar(__s32 fh, __s16 param, __u32 value);
int LxGpctControl(__s32 fh, __s16 function);
int LxGpctWatch(__s32 fh, __s16 function, __u32 *result);

#endif /* _NIDAQ_H */


