#define NI_MAX_BOARDS 16
#define NI_MAX_AICH 64

#define LOG(x,y){ FILE *l; l=fopen("log","a"); fprintf(l,x,y); fflush(l);fclose(l);}

#define NI_PCI  0x40000000 /* PCI board*/
#define NI_ESER 0x20000000 /* E series MIO board */
#define NI_8255 0x10000000 /* 8255 based DIO board */

#include "niboards.h"

typedef struct _device_info {
  char *dev_name;
  __u32 type; /* from nicts.h: it includes the board class & bus(ISA or PCI) */
  __u16 device_id; /* pci device id */
  __u16 aich, aires; /* no of channels & resolution in bits */
  __u32 aimaxspl; /* max spl. freq */
  __u16 aoch, aores; /* the same for ao */
  __u16 dioports, diosize; /* no of dioports & size in bits */
  struct _device_info *next;
} device_info;

#define NICTL_DEVICE_INFO _IOW('N', 100, 0)

#define NICTL_DIO_CONFPORT _IOW('N', 1, 0)
#define NICTL_DIO_SELPORT _IOW('N', 2, 0)
#define NICTL_DIO_WRMASK _IOW('N', 3, 0)

#define NICTL_AI_SCAN_START _IOW('N', 1, 0)
#define NICTL_AI_SCAN_SETUP _IOW('N', 2, 0)
#define NICTL_AI_RESET _IOW('N', 3, 0)
#define NICTL_AI_ADDCH _IOW('N', 4, 0)
#define NICTL_AI_ONEPT_SETUP _IOW('N', 5, 0)
#define NICTL_AI_CONVERT _IOW('N', 6, 0)
#define NICTL_AI_SET_SC _IOW('N', 7, 0)
#define NICTL_AI_SET_SI _IOW('N', 8, 0)
#define NICTL_AI_SET_SI2 _IOW('N', 9, 0)
#define NICTL_AI_TESTINT _IOW('N', 10, 0)
 
#define NICTL_AO_SET_CH _IOW('N', 50, 0)
#define NICTL_AO_RESET _IOW('N', 51, 0)

#define NICTL_GPCT_RESET _IOW('N', 1, 0)
#define NICTL_GPCT_APP_PULSE_TRAIN _IOW('N', 2, 0)
#define NICTL_GPCT_APP_PULSE  _IOW('N', 3, 0)
#define NICTL_GPCT_APP_PULSE_TRIG _IOW('N', 4, 0)
#define NICTL_GPCT_APP_PULSE_RETRIG _IOW('N', 5, 0)
#define NICTL_GPCT_APP_EVENT_CNT _IOW('N', 6, 0)
#define NICTL_GPCT_APP_PW_MEAS _IOW('N', 7, 0)
#define NICTL_GPCT_APP_PER_MEAS _IOW('N', 8, 0)
#define NICTL_GPCT_APP_BUF_PW_MEAS _IOW('N', 9, 0)
#define NICTL_GPCT_APP_BUF_PER_MEAS _IOW('N', 10, 0)
#define NICTL_GPCT_APP_BUF_SEM_MEAS _IOW('N', 11, 0)

#define NICTL_GPCT_PREPARE _IOW('N', 12, 0)
#define NICTL_GPCT_ARM _IOW('N', 13, 0)
#define NICTL_GPCT_READ _IOR('N', 14, 0)
#define NICTL_GPCT_ARMED _IOR('N', 28, 0)
#define NICTL_GPCT_DISARM _IOR('N', 15, 0)

#define NICTL_GPCT_SRC_SEL _IOW('N', 16, 0)
#define NICTL_GPCT_SRC_POL _IOW('N', 17, 0)
#define NICTL_GPCT_GATE_SEL _IOW('N', 18, 0)
#define NICTL_GPCT_GATE_POL _IOW('N', 19, 0)
#define NICTL_GPCT_OUT_MODE _IOW('N', 20, 0)
#define NICTL_GPCT_OUT_POL _IOW('N', 21, 0)
#define NICTL_GPCT_UP_DOWN _IOW('N', 22, 0)
#define NICTL_GPCT_SET_CNT1 _IOW('N', 23, 0)
#define NICTL_GPCT_SET_CNT2 _IOW('N', 24, 0)
#define NICTL_GPCT_SET_CNT3 _IOW('N', 25, 0)
#define NICTL_GPCT_SET_CNT4 _IOW('N', 26, 0)
#define NICTL_GPCT_SET_NPTS _IOW('N', 27, 0)



