#!/usr/bin/perl

open NIBOARDS, "<niboards" or die "can't read niboards";
open H, ">niboards.h" or die "can't write niboards.h";
open DEVINFO, ">device_info.h" or die "can't write device_info.h";

$items="";

while(<NIBOARDS>){
    next if /^#/ or /^\s*$/;
    ($name, $class, $rest)=/(\S+)\s+(\S+)\s+(.*)/;

    $type="0x$class";
    $ai="0,0,0"; $ao="0,0"; $dio="0,0"; $pci_code=0;

    for $pair (split /\s/){
	($l,$r)=$pair =~ /(.+)=(.+)/;
	if($l eq "type"){
	    if($r eq "E"){$type.=" | NI_ESER"; $dio="1,8"; }
	    if($r eq "D"){$type.=" | NI_8255";}
	    if($r eq "DE"){$type.=" | NI_ESER | NI_8255";}
	}
	if($l eq "pci"){
	    $type.=" | NI_PCI";
	    $pci_code=$r;
	}
	if($l eq "ai"){$ai=$r;}
	if($l eq "ao"){$ao=$r;}
	if($l eq "dio"){$dio=$r;}
    }
    
    $hname=$name;
    $hname =~ tr/A-Z\-/a-z_/;
    print DEVINFO "static device_info $hname = {\n";
    $items.=" additem(&$hname);\n";
    $hname =~ tr/a-z/A-Z/;
    print DEVINFO " \"$name\",\n NI_$hname,\n $pci_code,\n";
    print DEVINFO " $ai, // ai\n $ao, // ao\n $dio, // dio\n";
    print DEVINFO " NULL\n};\n\n";

  
    $hname=$hname." "x(20-length($name));
    print H "#define NI_$hname ($type)\n";
   
}
print DEVINFO "void init_device_info_list(void)\n{\n";
print DEVINFO $items;
print DEVINFO "}\n";
