#!/usr/bin/perl

open H, "<nicts.h" or die "can't read nicts.h";
while(<H>){
    if (/NI_PCI\s+(\S+)/) {$nipci=$1;}
    if (/NI_ESER\s+(\S+)/) {$nieser=$1;}
    if (/NI_8255\s+(\S+)/) {$ni8255=$1;}
}
close H;

open H, "niboards.h" or die "can't read niboards.h";
while(<H>){
    $type=0;
    ($name, $list)=/define\s+NI_(\S+)\s+\((.+)\)/;
    for $el (split /\W+/, $list){
	$el=$nipci if $el =~ /NI_PCI/;
	$el=$nieser if $el =~ /NI_ESER/;
	$el=$ni8255 if $el =~ /NI_8255/;
	$type |= oct($el);
    }
    $codes{$name}=sprintf ("0x%8x", $type);
}
close H;


open CONF, "<ni.conf" or die "can't open ni.conf";

$dev=0;
while(<CONF>){
    next if /^#/ or /^\s*$/;
    for $pair (split /\s/){
	($l,$r)=$pair=~/(.+)=(.+)/;
	if($l eq "type") {$r=&name2code($r);}
	$arg.=" $l$dev=$r";
    }
    $dev++;
}

system("cp /etc/conf.modules /etc/conf.modules.bak");
open CONFMODR, "</etc/conf.modules.bak";
open CONFMODW, ">/etc/conf.modules";
while(<CONFMODR>){
    next if (/options nidaq/);
    print CONFMODW $_;
}
print CONFMODW "options nidaq $arg\n" if $arg;
close CONFMODW;
close CONFMODR;

exit 0;

sub name2code{
    ($name)=@_;
    $name =~ tr/a-z\-/A-Z_/;
    return 0 if $name eq 0;
    unless (exists $codes{$name}) {die "board $name not supported\n";}
    return $codes{$name};
}
