#include <linux/fs.h>

#include "eserrlp.h"
#include "daq_driver.h"

static void AO_Write_1pt(pd dev, unsigned short uValue);
static void AO_Reset_All(pd dev);
static void AO_Board_Personalize(pd dev);
static void AO_LDAC_Source_And_Update_Mode(pd dev);

int ao_write(pd dev, struct file * file, char const * buf, int count)
{
  int i;
  unsigned short uValue;

  for(i=0;i<count/2;i++){
    copy_from_user (&uValue, buf+i*2, 2);   
    AO_Write_1pt(dev, uValue);
  }
  return count;

}

int ao_open(pd dev, struct file * file)
{
  return 0;
}

int ao_ioctl(pd dev, struct file *file, unsigned int cmd, unsigned long arg)
{
  switch(_IOC_NR(cmd)){
  case _IOC_NR(NICTL_AO_SET_CH):
    dev->ao_ch=arg;
    return 0;
  case _IOC_NR(NICTL_AO_RESET):
    AO_Reset_All(dev);
    return 0;
  }
  return -EINVAL;
}


static void AO_Write_1pt(pd dev, unsigned short uValue)
{ 
  /*
  * Configure the board.
  *
  * Writing to register AO_Configuration_Register with address 22.
  *    AO_DAC_Number_Select <= f2->f2_ao_channel_to_program (1)
  *    AO_DAC_Polarity <= p->dac_polarity (1)
  *    AO_DAC_Reference_Source <= p->dac_reference_source (0)
  *    AO_DAC_Low_Glitch <= p->dac_low_glitch (0)
  *    AO_DAC_Ground_Reference <= p->dac_ground_reference (26200)
  * New pattern = 0x0101
  */
  if(dev->ao_ch == 1)Board_Write(dev, AO_Configuration_Register,0x0101);
  else Board_Write(dev, AO_Configuration_Register,0x0001);

  AO_Reset_All(dev);

  AO_Board_Personalize(dev);
  
  /*
  * Program the LDAC outputs.
  */
  AO_LDAC_Source_And_Update_Mode(dev);

  /*                         
  * Write to the DAC.
  *
  * Writing to register AO_DAC_1_Data_Register with address 26.
  *    AO_DAC_1_Data <= p->dac_data_point (1024)
  * New pattern = 0x0400
  */
  if(dev->ao_ch == 1)Board_Write(dev, AO_DAC_1_Data_Register,uValue);
  else Board_Write(dev, AO_DAC_0_Data_Register,uValue);
                 
}

  /* 
  * Use this function to reset the DAQ-STC.
  */     

void AO_Reset_All(pd dev) /* as in STC manual */
{

  /*
  * Writing to register Joint_Reset_Register with address 72.
  *    AO_Configuration_Start <= 1
  * New pattern = 0x0020
  */
  DAQ_STC_Windowed_Mode_Strobe_Write(dev, Joint_Reset_Register,0x0020);

  /*
  * Writing to register AO_Command_1_Register with address 9.
  *    AO_Disarm <= 1
  * New pattern = 0x2000
  */
  DAQ_STC_Windowed_Mode_Strobe_Write(dev, AO_Command_1_Register,0x2000);

  DAQ_STC_Windowed_Mode_Write(dev, AO_Personal_Register, 0);
  DAQ_STC_Windowed_Mode_Write(dev, AO_Command_1_Register, 0);
  DAQ_STC_Windowed_Mode_Write(dev, AO_Command_2_Register, 0);
  DAQ_STC_Windowed_Mode_Write(dev, AO_Mode_1_Register, 0);
  DAQ_STC_Windowed_Mode_Write(dev, AO_Mode_2_Register, 0);
  DAQ_STC_Windowed_Mode_Write(dev, AO_Mode_3_Register, 0);
  DAQ_STC_Windowed_Mode_Write(dev, AO_Output_Control_Register, 0);
  DAQ_STC_Windowed_Mode_Write(dev, AO_START_Select_Register, 0);
  DAQ_STC_Windowed_Mode_Write(dev, AO_Trigger_Select_Register, 0);

  /*
  * Writing to register Interrupt_B_Enable_Register with address 75.
  *    AO_BC_TC_Interrupt_Enable <= 0
  *    AO_START1_Interrupt_Enable <= 0
  *    AO_UPDATE_Interrupt_Enable <= 0
  *    AO_START_Interrupt_Enable <= 0
  *    AO_STOP_Interrupt_Enable <= 0
  *    AO_Error_Interrupt_Enable <= 0
  *    AO_UC_TC_Interrupt_Enable <= 0
  *    AO_FIFO_Interrupt_Enable <= 0
  * New pattern = 0x0000
  */
  DAQ_STC_Windowed_Mode_Masked_Write(dev, Interrupt_B_Enable_Register,
				     0x0000, 0x017F);

  /*
  * Writing to register AO_Personal_Register with address 78.
  *    AO_BC_Source_Select <= 1
  * New pattern = 0x0010
  */
  DAQ_STC_Windowed_Mode_Masked_Write(dev, AO_Personal_Register,
				     0x0010, 0x0010);

  /*
  * Writing to register Interrupt_B_Ack_Register with address 3.
  *    AO_BC_TC_Trigger_Error_Confirm <= 1
  *    AO_BC_TC_Error_Confirm <= 1
  *    AO_UC_TC_Interrupt_Ack <= 1
  *    AO_BC_TC_Interrupt_Ack <= 1
  *    AO_START1_Interrupt_Ack <= 1
  *    AO_UPDATE_Interrupt_Ack <= 1
  *    AO_START_Interrupt_Ack <= 1
  *    AO_STOP_Interrupt_Ack <= 1
  *    AO_Error_Interrupt_Ack <= 1
  * New pattern = 0x3F98
  */
  DAQ_STC_Windowed_Mode_Masked_Write(dev, Interrupt_B_Ack_Register,
				     0x3F98, 0x3F98);

    /*
  * Writing to register Joint_Reset_Register with address 72.
  *    AO_Configuration_Start <= 0
  *    AO_Configuration_End <= 1
  * New pattern = 0x0200
  */
  DAQ_STC_Windowed_Mode_Write(dev, Joint_Reset_Register,0x0200);
}
  
void AO_Board_Personalize(pd dev) /* as in STC manual */
{
  /*
  * Writing to register Joint_Reset_Register with address 72.
  *    AO_Configuration_Start <= 1
  * New pattern = 0x0020
  */
  DAQ_STC_Windowed_Mode_Write(dev, Joint_Reset_Register,0x0020);

  /*
  * Writing to register AO_Personal_Register with address 78.
  *    AO_Fast_CPU <= p->ao_fast_cpu (0)
  *    AO_UPDATE_Pulse_Timebase <= p->ao_update_pulse_timebase (0)
  *    AO_UPDATE_Pulse_Width <= p->ao_update_pulse_width (1)
  *    AO_DMA_PIO_Control <= p->ao_dma_pio_control (0)
  *    AO_AOFREQ_Polarity <= p->ao_dafreq_polarity (0)
  *    AO_TMRDACWR_Pulse_Width <= p->ao_tmrdacwr_pulse_width (1)
  *    AO_FIFO_Enable <= p->ao_fifo_enable (1)
  *    AO_FIFO_Flags_Polarity <= p->ao_fifo_flags_polarity (0)
  *    AO_Number_Of_DAC_Packages <= p->ao_number_of_dac_packages (0)
  * New pattern = 0x1430
  */
  DAQ_STC_Windowed_Mode_Masked_Write(dev, AO_Personal_Register,0x1420,0x7F60);

  /*
  * Writing to register Clock_and_FOUT_Register with address 56.
  *    AO_Source_Divide_By_2 <= p->ao_source_divide_by_2 (0)
  *    AO_Output_Divide_By_2 <= p->ao_output_divide_by_2 (1)
  * New pattern = 0x1B20
  */
  DAQ_STC_Windowed_Mode_Masked_Write(dev, Clock_and_FOUT_Register,
				     0x0020, 0x0030);

  /*
  * Writing to register AO_Output_Control_Register with address 86.
  *    AO_UPDATE_Output_Select <= p->ao_update_output_select (0)
  * New pattern = 0x0000
  */
  DAQ_STC_Windowed_Mode_Masked_Write(dev, AO_Output_Control_Register,
				     0x0000, 0x0003);

  /*
  * Writing to register AO_START_Select_Register with address 66.
  *    AO_AOFREQ_Enable <= p->ao_dafreq_enable (0)
  * New pattern = 0x0000
  */
  DAQ_STC_Windowed_Mode_Masked_Write(dev, AO_START_Select_Register,
				     0x0000, 0x1000);
  
  /*
  * Writing to register Joint_Reset_Register with address 72.
  *    AO_Configuration_Start <= 0
  *    AO_Configuration_End <= 1
  * New pattern = 0x0200
  */
  DAQ_STC_Windowed_Mode_Strobe_Write(dev, Joint_Reset_Register,0x0200);

}                 

/*
* Use this function to set the source and update mode for the LDAC<0..1> 
* signals.
*/
                                                        
void AO_LDAC_Source_And_Update_Mode(pd dev) /* as in STC manual */
{

  /*
  * Writing to register Joint_Reset_Register with address 72.
  *    AO_Configuration_Start <= 1
  * New pattern = 0x0020
  */
  DAQ_STC_Windowed_Mode_Strobe_Write(dev, Joint_Reset_Register,0x0020);

  /*
  * Writing to register AO_Command_1_Register with address 9.
  *    AO_LDAC0_Source_Select <= p->ao_ldac0_source_select (0)
  *    AO_DAC0_Update_Mode <= p->ao_dac0_update_mode (0)
  *    AO_LDAC1_Source_Select <= p->ao_ldac1_source_select (0)
  *    AO_DAC1_Update_Mode <= p->ao_dac1_update_mode (0)
  * New pattern = 0x0014
  */
  DAQ_STC_Windowed_Mode_Masked_Write(dev, AO_Command_1_Register,
				     0x0000, 0x001E);

  /*
  * Writing to register Joint_Reset_Register with address 72.
  *    AO_Configuration_Start <= 0
  *    AO_Configuration_End <= 1
  * New pattern = 0x0200
  */
  DAQ_STC_Windowed_Mode_Strobe_Write(dev, Joint_Reset_Register,0x0200);

}



